function femmodel=transient3d_core(femmodel)
%TRANSIENT3D_CORE - core of transient 2d solution
%
%   Usage:
%      femmodel=transient3d_core(femmodel)

	%recover parameters common to all solutions
	dim=femmodel.parameters.Dim;
	ndt=femmodel.parameters.Ndt;
	dt=femmodel.parameters.Dt;
	yts=femmodel.parameters.ConstantsYts;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;
	output_frequency=femmodel.parameters.OutputFrequency;
	time_adapt=femmodel.parameters.TimeAdapt;
	isdiagnostic=femmodel.parameters.Isdiagnostic;
	isprognostic=femmodel.parameters.Isprognostic;
	isthermal=femmodel.parameters.Isthermal;

	%Initialize
	time=0;
	step=0;

	%Loop through time
	while (time < ndt - (yts*eps)),

		%Increment
		if(time_adapt),
			dt=TimeAdapt(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
			if(time+dt>ndt), dt=ndt-time; end
			femmodel.parameters.Dt=dt;
		end
		step=step+1;
		time=time+dt;
		femmodel.parameters.Time=time;

		issmprintf(VerboseSolution,'\n%s%g%s%i%s%g\n','time [yr] ',time/yts,' iteration number: ',step,'/',floor(ndt/dt));

		if (isthermal & dim==3)
			issmprintf(VerboseSolution,'\n%s',['   computing temperature']);
			femmodel=thermal_core_step(femmodel); 
		end

		if (isdiagnostic)
			issmprintf(VerboseSolution,'\n%s',['   computing new velocities']);
			femmodel=diagnostic_core(femmodel); 
		end

		if (isprognostic)
			issmprintf(VerboseSolution,'\n%s',['   computing new thickness']);
			femmodel=prognostic_core(femmodel); 
			issmprintf(VerboseSolution,'\n%s',['   updating vertices position']);
			[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=...
				UpdateVertexPositions(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
		end

		if (solution_type==TransientSolutionEnum & ~control_analysis & (mod(step,output_frequency)==0 | time==ndt)),
			issmprintf(VerboseSolution,'\n%s',['   saving results']);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum,step,time);
			if (dim==3), femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VzEnum,step,time); end
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VelEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ThicknessEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BedEnum,step,time);
			if (dim==3), femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum,step,time);end
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BasalMeltingRateEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceMassBalanceEnum,step,time);
		end
	end
end %end of function
