/*\file Dakota.c
 *\brief: launch solution core using Dakota engine.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Dakota.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	mxArray    *femmodel   = NULL;

	/* output datasets: none*/

	#ifndef _HAVE_DAKOTA_ //only works if dakota library has been compiled in.
	_error_(" Dakota not available! Cannot carry out qmu analysis!");
	#endif

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&DakotaUsage);

	/*Input datasets: */
	femmodel=FEMMODEL;

	/*!Generate internal degree of freedom numbers: */
	Dakotax(femmodel);

	/*end module: */
	MODULEEND();


}

void DakotaUsage(void){
	_printf_(true,"\n");
	_printf_(true,"   usage: %s(femmodel);\n",__FUNCT__);
	_printf_(true,"\n");
}
