/*!\file: controlrestart.cpp
 * \brief: save as much as possible, to be able to restart the control_core solution
 */ 

#include "./solutions.h"
#include "../modules/modules.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void controlrestart(FemModel* femmodel,double* J){

	int      num_controls;
	int*     control_type = NULL;
	int      nsteps;
	bool     dakota_analysis=true;

	/*retrieve output file name: */
	femmodel->parameters->FindParam(&num_controls,NumControlTypeEnum);
	femmodel->parameters->FindParam(&control_type,NULL,ControlTypeEnum);
	femmodel->parameters->FindParam(&nsteps,NstepsEnum);
	femmodel->parameters->FindParam(&dakota_analysis,DakotaAnalysisEnum);

	/*only save if we are not running qmu analysis. We certainly don't want to save control results each time we 
	 * run on control core!: */
	if(!dakota_analysis){
		/*we essentially want J and the parameter: */
		for(int i=0;i<num_controls;i++) InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,control_type[i]);
		femmodel->results->AddObject(new DoubleVecExternalResult(femmodel->results->Size()+1,JEnum,J,nsteps,1,0));
		//femmodel->results->AddObject(new StringExternalResult(femmodel->results->Size()+1,ControlTypeEnum,EnumToStringx(control_type),1,0));

		/*write to disk: */
		OutputResultsx(femmodel->elements, femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,&femmodel->results);
	}

	/*Clean up and return*/
	xfree((void**)&control_type);
}
