function [solutioncore]=CorePointerFromSolutionEnum(parameters,solutiontype),
%COREPOINTERFROMSOLUTIONENUM - returns solution_core function
%
%   Usage:
%      [solutioncore]=CorePointerFromSolutionEnum(parameters,solutiontype);

control_analysis=parameters.ControlAnalysis;
dakota_analysis=parameters.DakotaAnalysis;

switch solutiontype,

	case DiagnosticSolutionEnum,               solutioncore='diagnostic_core';
	case SteadystateSolutionEnum,              solutioncore='steadystate_core';
	case ThermalSolutionEnum,                  solutioncore='thermal_core';
	case EnthalpySolutionEnum,                 solutioncore='enthalpy_core';
	case PrognosticSolutionEnum,               solutioncore='prognostic_core';
	case BalancethicknessSolutionEnum,         solutioncore='balancethickness_core';
	case SurfaceSlopeSolutionEnum,             solutioncore='surfaceslope_core';
	case BedSlopeSolutionEnum,                 solutioncore='bedslope_core';
	case TransientSolutionEnum,                solutioncore='transient_core';
	case FlaimSolutionEnum,                    solutioncore='flaim_core';
	case GroundinglineMigration2DSolutionEnum, solutioncore='DUMMYDUMMY'; %not working in serial mode
	case HydrologySolutionEnum,                solutioncore='DUMMYDUMMY'; %not working in serial mode
	otherwise error('%s%s%s',' solution type: ',EnumToString(solutiontype),' not supported yet!');

end

%if control being run on top of solution, change core
if(control_analysis)solutioncore='control_core';end
