function md=loadresultsfromdisk(md,filename)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%check number of inputs/outputs
if ((nargin~=2) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end

if ~md.dakota_analysis,

	%initialize md.results if not a structure yet
	if ~isstruct(md.results),
		md.results=struct();
	end

	%load results onto model
	structure=parseresultsfromdisk(filename,~md.io_gather);
	md.results.(structure(1).SolutionType)=structure;

	%recover solution_type from results
	md.solution_type=structure(1).SolutionType;

%post processes qmu results if necessary
else

	if isscalar(md.solution_type),
		md.solution_type    =EnumToString(md.solution_type);
	end
	md=postqmu(md);
	cd ..

end
