function displayparallel(md)
%DISPLAYPARALLEL - display parallel computation parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays all fields related to
%   parallel computation from model md, only if requested.
%
%   Usage:
%      displayparallel(md)

disp(sprintf('   parallel computation parameters:'));
disp('Cluster:');
disp(md.cluster)
fielddisplay(md,'alloc_cleanup','allocation cleanup before starting a job, default 1');
fielddisplay(md,'waitonlock','maximum number of minutes to wait for batch results, or return 0');
