function femmodel=solver_thermal_nonlinear(femmodel)
%SOLVER_THERMAL_NONLINEAR - core of thermal solution sequence.
%   femmodel is returned together with temperature and melting_offset, in case loads have been modified
%
%   Usage:
%      [femmodel]=solver_thermal_nonlinear(femmodel)

	count=1;
	converged=0;

	%Get parameters
	configuration_type=femmodel.parameters.ConfigurationType;

	issmprintf(VerboseConvergence(),'\n%s',['   starting direct shooting method']);

	%Reset penalties and initialize convergence as false
	[femmodel.elements loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,0,ConvergedEnum);
	[femmodel.elements femmodel.loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,1,ResetPenaltiesEnum);

	%update constraints
	[femmodel.nodes]=UpdateConstraints(femmodel.nodes,femmodel.constraints,femmodel.parameters);

	while(~converged),

		[K_ff,K_fs,p_f,d_f,melting_offset]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
		ys=CreateNodalConstraints(femmodel.nodes,configuration_type);
		p_f = Reduceload( p_f, K_fs, ys);

		issmprintf(VerboseSolver(),'%s%g','   condition number of stiffness matrix: ',condest(K_ff));
		t_f=Solver(K_ff,p_f,[],d_f,femmodel.parameters);
		t_g= Mergesolutionfromftog( t_f, ys, femmodel.nodes,femmodel.parameters); 

		[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,t_g);
		[femmodel.loads,constraints_converged,num_unstable_constraints] =ConstraintsState(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters);
	
		if ~converged,
			issmprintf(VerboseConvergence(),'%s%i','   #unstable constraints ',num_unstable_constraints);
			if num_unstable_constraints<=femmodel.parameters.MinThermalConstraints,
				converged=1;
			end
		end
		[femmodel.elements loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,double(converged),ConvergedEnum);
		count=count+1;
	end

	[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,t_g);
	[femmodel.elements femmodel.loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,melting_offset,MeltingOffsetEnum);
end
