
for j=1:13,

	m=md.qmu_mass_flux_segments{j};
	s=size(m);s=s(1);

	flux=0;
	for i=1:s(1),

		x1=m(i,1);
		y1=m(i,2);
		x2=m(i,3);
		y2=m(i,4);

		plot([x1 x2],[y1 y2],'r-');

		%compute mass flux: 
		normal=zeros(2,1);
		normal(1)=cos(atan2(x1-x2,y2-y1));
		normal(2)=sin(atan2(x1-x2,y2-y1));

		length=sqrt((x2-x1)^2+(y2-y1)^2);

		h=InterpFromMeshToMesh2D(md.elements,md.x,md.y,md.thickness,(x1+x2)/2,(y1+y2)/2);
		vx=InterpFromMeshToMesh2D(md.elements,md.x,md.y,md.vx,(x1+x2)/2,(y1+y2)/2);
		vy=InterpFromMeshToMesh2D(md.elements,md.x,md.y,md.vy,(x1+x2)/2,(y1+y2)/2);

		flux=flux+md.rho_ice*length*h*(vx*normal(1)+vy*normal(2));

	end
	disp(sprintf('%i: %.2g\n',j,flux/10^12));
end
