/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#include "../../Container/Container.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "../../io/io.h"
#include "./ModelProcessorx.h"

void CreateParameters(Parameters** pparameters,IoModel* iomodel,const int solution_type,int analysis_type,int analysis_counter){
	
	int         i;
	int         numoutputs;
	Parameters *parameters       = NULL;
	double     *requestedoutputs = NULL;
	
	if(*pparameters)return; //do not create parameters twice!

	/*Initialize dataset: */
	parameters = new Parameters(ParametersEnum);
		
	/*Copy some constants from iomodel */
	parameters->AddObject(iomodel->CopyConstantObject(DimEnum));
	parameters->AddObject(iomodel->CopyConstantObject(IshutterEnum));
	parameters->AddObject(iomodel->CopyConstantObject(IsmacayealpattynEnum));
	parameters->AddObject(iomodel->CopyConstantObject(IsstokesEnum));
	parameters->AddObject(iomodel->CopyConstantObject(OutputFrequencyEnum));
	parameters->AddObject(iomodel->CopyConstantObject(EpsResEnum));
	parameters->AddObject(iomodel->CopyConstantObject(EpsRelEnum));
	parameters->AddObject(iomodel->CopyConstantObject(EpsAbsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MaxNonlinearIterationsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MaxSteadystateIterationsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(EpsvelEnum));
	parameters->AddObject(iomodel->CopyConstantObject(YtsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DtEnum));
	parameters->AddObject(iomodel->CopyConstantObject(NdtEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TimeAdaptEnum));
	parameters->AddObject(iomodel->CopyConstantObject(CflCoefficientEnum));
	parameters->AddObject(iomodel->CopyConstantObject(HydrostaticAdjustmentEnum));
	parameters->AddObject(iomodel->CopyConstantObject(PenaltyOffsetEnum));
	parameters->AddObject(iomodel->CopyConstantObject(LowmemEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ConnectivityEnum));
	parameters->AddObject(iomodel->CopyConstantObject(BetaEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MeltingpointEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ReferencetemperatureEnum));
	parameters->AddObject(iomodel->CopyConstantObject(LatentheatEnum));
	parameters->AddObject(iomodel->CopyConstantObject(HeatcapacityEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ArtificialDiffusivityEnum));
	parameters->AddObject(iomodel->CopyConstantObject(GroundinglineMeltingRateEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MinThermalConstraintsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MinMechanicalConstraintsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(StabilizeConstraintsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(StokesreconditioningEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ShelfDampeningEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ViscosityOvershootEnum));
	parameters->AddObject(iomodel->CopyConstantObject(WaitonlockEnum));
	parameters->AddObject(iomodel->CopyConstantObject(NumberOfElementsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(IoGatherEnum));
	parameters->AddObject(iomodel->CopyConstantObject(GroundinglineMigrationEnum));
	parameters->AddObject(iomodel->CopyConstantObject(IsdiagnosticEnum));
	parameters->AddObject(iomodel->CopyConstantObject(IsprognosticEnum));
	parameters->AddObject(iomodel->CopyConstantObject(IsthermalEnum));

	/*Some parameters need to be processed from iomodel*/
	char* rheology_law = NULL;
	iomodel->Constant(&rheology_law,RheologyLawEnum);
	if      (strcmp(rheology_law,"none")==0)      parameters->AddObject(new IntParam(RheologyLawEnum,NoneEnum));
	else if (strcmp(rheology_law,"paterson")==0)  parameters->AddObject(new IntParam(RheologyLawEnum,PatersonEnum));
	else if (strcmp(rheology_law,"arrhenius")==0) parameters->AddObject(new IntParam(RheologyLawEnum,ArrheniusEnum));
	else _error_("Rheology law %s not supported",rheology_law);
	xfree((void**)&rheology_law);

	/*some parameters that did not come with the iomodel: */
	parameters->AddObject(new IntParam(SolutionTypeEnum,solution_type));
	parameters->AddObject(new IntParam(AnalysisTypeEnum,analysis_type));
	parameters->AddObject(new IntParam(AnalysisCounterEnum,analysis_counter));
	parameters->AddObject(new DoubleParam(TimeEnum,0.0));  //start at time 0 by default for all solutions

	/*Requested output?*/
	iomodel->FetchData(&requestedoutputs,&numoutputs,NULL,RequestedOutputsEnum);
	parameters->AddObject(new IntParam(NumRequestedOutputsEnum,numoutputs));
	if(numoutputs)parameters->AddObject(new IntVecParam(RequestedOutputsEnum,requestedoutputs,numoutputs));
	xfree((void**)&requestedoutputs);
	
	/*Before returning, create parameters in case we are running Qmu or control types runs: */
	CreateParametersControl(&parameters,iomodel,solution_type,analysis_type);
	CreateParametersQmu(&parameters,iomodel,solution_type,analysis_type);

	/*Go through all parameters, and convert units to SI: */
	parameters->UnitConversion(ExtToIuEnum);

	/*Assign output pointer: */
	*pparameters=parameters;
}
