/*!\file: CreateParametersControl.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void CreateParametersControl(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){
	
	int         i;
	Parameters *parameters       = NULL;
	bool        control_analysis;
	int         nsteps;
	int         num_control_type;
	int         num_cm_responses;
	int        *control_type     = NULL;
	double     *cm_responses     = NULL;
	double     *cm_jump          = NULL;
	double     *optscal          = NULL;
	double     *maxiter          = NULL;

	/*Get parameters: */
	parameters=*pparameters;

	/*retrieve some parameters: */
	iomodel->Constant(&control_analysis,ControlAnalysisEnum);
	parameters->AddObject(new BoolParam(ControlAnalysisEnum,control_analysis));

	if(control_analysis){

		/*How many controls and how many responses?*/
		parameters->AddObject(iomodel->CopyConstantObject(NumControlTypeEnum));
		parameters->AddObject(iomodel->CopyConstantObject(NumCmResponsesEnum));
		parameters->AddObject(iomodel->CopyConstantObject(NstepsEnum));
		parameters->AddObject(iomodel->CopyConstantObject(TolxEnum));
		parameters->AddObject(iomodel->CopyConstantObject(EpsCmEnum));
		parameters->AddObject(iomodel->CopyConstantObject(CmGradientEnum));
		parameters->AddObject(iomodel->CopyConstantObject(MeanvelEnum));

		/*What solution type?*/
		if (solution_type==SteadystateSolutionEnum){
			parameters->AddObject(new BoolParam(ControlSteadyEnum,true));
		}
		else{
			parameters->AddObject(new BoolParam(ControlSteadyEnum,false));
		}

		/*Now, recover fit, optscal and maxiter as vectors: */
		iomodel->FetchData(&control_type,NULL,&num_control_type,ControlTypeEnum);
		iomodel->FetchData(&cm_responses,&nsteps,&num_cm_responses,CmResponsesEnum);
		iomodel->FetchData(&cm_jump,&nsteps,NULL,CmJumpEnum);
		iomodel->FetchData(&optscal,NULL,NULL,OptscalEnum);
		iomodel->FetchData(&maxiter,NULL,NULL,MaxiterEnum);

		parameters->AddObject(new IntVecParam(ControlTypeEnum,control_type,num_control_type));
		parameters->AddObject(new DoubleMatParam(OptscalEnum,optscal,nsteps,num_control_type));
		parameters->AddObject(new DoubleMatParam(CmResponsesEnum,cm_responses,nsteps,num_cm_responses));
		parameters->AddObject(new DoubleVecParam(CmJumpEnum,cm_jump,nsteps));
		parameters->AddObject(new DoubleVecParam(MaxiterEnum,maxiter,nsteps));

		xfree((void**)&control_type);
		xfree((void**)&cm_responses);
		xfree((void**)&cm_jump);
		xfree((void**)&optscal);
		xfree((void**)&maxiter);
	}

	/*Assign output pointer: */
	*pparameters=parameters;
}
