function md=reorder(md)
%REORDER - reorder nodes and elements of a model
%
%   Usage: 
%      md=reorder(md)

%some checks
if md.dim==3,
	error('reorder error message: 3d models not supported yet, exiting...')
end
disp('reorder warning: only the mesh fields are reorder. The model needs to be reparameterized');

%reorder elements
newelements=randperm(md.numberofelements)';
tnewelements=zeros(md.numberofelements,1);tnewelements(newelements)=[1:md.numberofelements]';

%reorder nodes
newnodes=randperm(md.numberofnodes)';
tnewnodes=zeros(md.numberofnodes,1);tnewnodes(newnodes)=[1:md.numberofnodes]';

%update all fields
md.elements=tnewnodes(md.elements(newelements,:));
md.segments=[tnewnodes(md.segments(:,1)) tnewnodes(md.segments(:,2)) tnewelements(md.segments(:,3))];
md.x=md.x(newnodes);
md.y=md.y(newnodes);
md.z=md.z(newnodes);
md.nodeonboundary=zeros(md.numberofnodes,1); md.nodeonboundary(md.segments(:,1:2))=1;
