function md=meshrefine(md,areas)
%MESHREFINE:  refined the mesh from a model, according to an area metric.
%
%   Usage:
%      md=meshrefine(md,metric)

%some checks on list of arguments
if ((nargin~=2) | (nargout~=1)),
	meshrefineusage();
	error('meshrefine error message');
end
if ( (isempty(areas)) |  (length(areas)~=md.numberofelements) | (length(find(isnan(areas))))),
	meshrefineusage();
	error('meshrefine error message');
end

%Refine using TriMeshRefine
%[md.elements,md.x,md.y,md.segments,md.rifts]=TriMeshRefine(md.elements,md.x,md.y,md.segments,md.rifts,areas,'yes');
[md.elements,md.x,md.y,md.segments,md.segmentmarkers]=TriMeshRefine(md.elements,md.x,md.y,md.segments,md.segmentmarkers,areas,'yes');

%Fill in rest of fields:
md.numberofelements=length(md.elements);
md.numberofnodes=length(md.x);
md.z=zeros(md.numberofnodes,1);
md.nodeonboundary=zeros(md.numberofnodes,1); md.nodeonboundary(md.segments(:,1:2))=1;
md.nodeonbed=ones(md.numberofnodes,1);
md.nodeonsurface=ones(md.numberofnodes,1);
md.elementonbed=ones(md.numberofelements,1);
md.elementonsurface=ones(md.numberofelements,1);

%Now, build the connectivity tables for this mesh.
md.nodeconnectivity=NodeConnectivity(md.elements,md.numberofnodes);
md.elementconnectivity=ElementConnectivity(md.elements,md.nodeconnectivity);

%type of model
md.dim=2;
end

function meshrefineusage(),
disp('usage: md=meshrefine(md,areas)');
end
