function md=geography(md,iceshelfname,icesheetname)
%GEOGRAPHY - establish boundaries between grounded and floating ice.
%
%   By default, ice is considered grounded. The contour iceshelfname defines nodes 
%   for which ice is floating. The contour icesheetname defines nodes inside an iceshelf, 
%   that are grounded (ie: ice rises, islands, etc ...)
%   All input files are in the Argus format (extension .exp).
%
%   Usage:
%      md=geography(md,iceshelfname,icesheetname)
%
%   Examples:
%      md=geography(md,'all','');
%      md=geography(md,'Iceshelves.exp','Islands.exp');

%some checks on list of arguments
if ((nargin~=3) | (nargout~=1)),
	help geography
	error('geography error message');
end

%Get assigned fields
x=md.x;
y=md.y;
elements=md.elements;

%Assign elementoniceshelf, elementonicesheet, nodeonicesheet and nodeoniceshelf. Only change at your own peril! This is synchronized heavily with the GroundingLineMigration module. {{{1
elementoniceshelf=FlagElements(md,iceshelfname);
elementonicesheet=FlagElements(md,icesheetname);

%Because icesheet nodes and elements can be included into an iceshelf, we need to update. Remember, all the previous 
%arrays come from domain outlines that can intersect one another: 
elementoniceshelf=double((elementoniceshelf & ~elementonicesheet));
elementonicesheet=double(~elementoniceshelf);

%the order here is important. we choose nodeonicesheet as default on the grounding line.
nodeoniceshelf=zeros(md.numberofnodes,1);
nodeonicesheet=zeros(md.numberofnodes,1);
nodeonicesheet(md.elements(find(elementonicesheet),:))=1;
nodeoniceshelf(find(~nodeonicesheet))=1;
%}}}

%Return: 
md.elementoniceshelf=elementoniceshelf;
md.nodeoniceshelf=nodeoniceshelf;

md.elementonicesheet=elementonicesheet;
md.nodeonicesheet=nodeonicesheet;

md.nodeonwater=zeros(md.numberofnodes,1);
md.elementonwater=zeros(md.numberofelements,1);
