function div=divergence(md,a,b)
%DIVERGENCE - divergence of [a;b] vector, using model's triangulation.
%
%   Usage:
%      div=divergence(md,a,b)

if (md.dim==2),
	numberofelements=md.numberofelements;
	numberofnodes=md.numberofnodes;
	index=md.elements;
	x=md.x; y=md.y; z=md.z;
else
	numberofelements=md.numberofelements2d;
	numberofnodes=md.numberofnodes2d;
	index=md.elements2d;
	x=md.x2d; y=md.y2d;
end

%compute nodal functions coefficients N(x,y)=alpha x + beta y + gamma
[alpha beta]=GetNodalFunctionsCoeff(index,x,y);

summation=[1;1;1];
dx=(a(index).*alpha)*summation;
dy=(b(index).*beta)*summation;

div=dx+dy;
div=averaging(md,div,1);
