function displayparameters(md)
%DISPLAYPARAMETERS - display parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays parameters from model md, 
%   only if requested.
%
%   Usage:
%      displayparameters(md)

disp(sprintf('   Parameters:'));

disp(sprintf('\n      geometrical parameters:'));
fielddisplay(md,'surface','surface height [m]');
fielddisplay(md,'thickness','thickness [m]');
fielddisplay(md,'bed','bed height [m]');
fielddisplay(md,'bathymetry','bathymetry elevation (with respect to sea level) [m]');
fielddisplay(md,'firn_layer','firn layer height [m]');
fielddisplay(md,'elementonbed','element on bed flags list');
fielddisplay(md,'elementonsurface','element on surface flags list');
fielddisplay(md,'nodeonbed','node on bed flags list');
fielddisplay(md,'nodeonsurface','node on surface flags list');

disp(sprintf('\n      physical parameters:'));
fielddisplay(md,'g','acceleration due to gravity [m/s^2]');

disp(sprintf('\n      Friction parameters (Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_ice*g*bed, r=q/p and s=1/p)'));
fielddisplay(md,'drag_coefficient','friction coefficient [IS]');
fielddisplay(md,'drag_p','p exponent');
fielddisplay(md,'drag_q','q exponent');
