/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

#include "../modules/EnumToStringx/EnumToStringx.h"
#include "../modules/StringToEnumx/StringToEnumx.h"

enum definitions{
	/*Datasets {{{1*/
	ConstraintsEnum,
	DatasetsEnum,
	ElementsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ParametersEnum,
	ResultsEnum,
	VerticesEnum,
	/*}}}*/
	/*Solution types {{{1 */
	SolutionTypeEnum,
	/*}}}*/
	/*Analysis types {{{1 */
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AnalysisCounterEnum,
	//diagnostic
	DiagnosticSolutionEnum,
	DiagnosticAnalysisEnum,
	DiagnosticHorizAnalysisEnum,
	DiagnosticVertAnalysisEnum,
	DiagnosticHutterAnalysisEnum,
	//control
	AdjointSolutionEnum,
	AdjointHorizAnalysisEnum,
	AdjointBalancethicknessAnalysisEnum,
	ControlAnalysisEnum,
	GradientAnalysisEnum,
	InverseAnalysisEnum,
	//thermal
	ThermalSolutionEnum,
	ThermalAnalysisEnum,
	//hydro
	HydrologySolutionEnum,
	HydrologyAnalysisEnum,
	//transient
	TransientSolutionEnum,
	GroundinglineMigration2DSolutionEnum,
	SteadyAnalysisEnum,
	TransientAnalysisEnum, // needed by nighly run (to be removed at some point?)
	//slope
	BedSlopeSolutionEnum,
	BedSlopeAnalysisEnum,
	SurfaceSlopeSolutionEnum,
	SurfaceSlopeAnalysisEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	//prognostic
	BalancethicknessSolutionEnum,
	BalancethicknessAnalysisEnum,
	Fake31Enum,
	Fake32Enum,
	PrognosticSolutionEnum,
	PrognosticAnalysisEnum,
	//melting
	MeltingAnalysisEnum,
	//parameters
	ParametersSolutionEnum,
	ParametersAnalysisEnum,
	//steadystate
	SteadystateSolutionEnum,
	SteadystateAnalysisEnum,
	//flaim
	FlaimSolutionEnum,
	FlaimAnalysisEnum,
	//none
	NoneAnalysisEnum,
	/*}}}*/
	/*Approximations {{{1*/
	ApproximationEnum,
	HutterApproximationEnum,
	MacAyealApproximationEnum,
	MacAyealPattynApproximationEnum,
	MacAyealStokesApproximationEnum,
	NoneApproximationEnum,
	PattynApproximationEnum,
	PattynStokesApproximationEnum,
	StokesApproximationEnum,
	/*}}}*/
	/*Objects {{{1*/
	ObjectEnum,
	HookEnum,
	SegmentEnum,
	/*Elements: */
	ElementEnum,
	DofIndexingEnum,
	ElementPropertiesEnum,
	NodePropertiesEnum,
	PentaEnum,
	TriaEnum,
	/*Nodes: */
	NodeEnum,
	VertexEnum,
	/*Loads: */
	LoadEnum,
	IcefrontEnum,
	NumericalfluxEnum,
	PengridEnum,
	PenpairEnum,
	QuadRiftFrontEnum,
	RiftfrontEnum,
	SegmentRiftfrontEnum,
	MacAyeal2dIceFrontEnum,
	MacAyeal3dIceFrontEnum,
	PattynIceFrontEnum,
	StokesIceFrontEnum,
	/*Materials: */
	MaterialEnum,
	MaticeEnum,
	MatparEnum,
	/*Inputs: */
	InputEnum,
	BoolInputEnum,
	DoubleInputEnum,
	IntInputEnum,
	PentaVertexInputEnum,
	TriaVertexInputEnum,
	Fake0Enum, 
	Fake1Enum,
	ControlInputEnum,
	/*Params: */
	ParamEnum,
	BoolParamEnum,
	DoubleMatParamEnum,
	DoubleMatArrayParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	IntParamEnum,
	IntVecParamEnum,
	FileParamEnum,
	PetscMatParamEnum,
	PetscVecParamEnum,
	StringArrayParamEnum,
	StringParamEnum,
	/*Results: */
	ElementResultEnum,
	ExternalResultEnum,
	/*Spc: */
	SpcStaticEnum,
	SpcTransientEnum,
	/*}}}*/
	/*Geography {{{1*/
	GeographyEnum,
	IceSheetEnum,
	IceShelfEnum,
	/*}}}*/
	/*Fill {{{1*/
	WaterEnum,
	IceEnum,
	AirEnum,
	MelangeEnum,
	/*}}}*/
	/*Rift state {{{1*/
	FreeEnum,
	OpenEnum,
	ClosedEnum,
	/*}}}*/
	/*Inputs {{{1*/
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	AdjointpEnum,
	Fake35Enum,
	BedEnum,
	BathymetryEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	CmResponseEnum,
	CmResponsesEnum,
	Fake2Enum,
	ConstantEnum,
	Fake37Enum,
	ControlTypeEnum,
	ConvergedEnum,
	Fake3Enum,
	DragCoefficientEnum,
	DragPEnum,
	DragQEnum,
	Fake41Enum,
	DtEnum,
	TimeAdaptEnum,
	CflCoefficientEnum,
	ElementOnBedEnum,
	ElementOnIceShelfEnum,
	ElementOnSurfaceEnum,
	ElementOnWaterEnum,
	Fake4Enum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	Fake5Enum,
	HydrostaticAdjustmentEnum,
	InternalEnum,
	KflagEnum,
	IuToExtEnum,
	ExtToIuEnum,
	MassFluxEnum,
	ThicknessAbsMisfitEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceAverageVelMisfitEnum,
	MaxPenetrationEnum,
	Fake6Enum,
	MeltingOffsetEnum,
	GroundinglineMeltingRateEnum,
	BasalMeltingRateEnum,
	MisfitEnum,
	NodeOnBedEnum,
	NodeOnIceSheetEnum,
	NodeOnIceShelfEnum,
	NodeOnSurfaceEnum,
	NumberNodeToElementConnectivityEnum,
	PenaltyOffsetEnum,
	PflagEnum,
	PressureEnum,
	PressurePicardEnum,
	VelocityEnum,
	QmuPressureEnum,
	ResetPenaltiesEnum,
	RheologyBEnum,
	RheologyBbarEnum,
	RheologyNEnum,
	SegmentOnIceShelfEnum,
	ShelfDampeningEnum,
	StabilizeConstraintsEnum,
	Fake7Enum,
	SurfaceAccumulationRateEnum,
	SurfaceAblationRateEnum,
	SurfaceAreaEnum,
	SurfaceEnum,
	SurfaceMassBalanceEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePicardEnum,
	TemperatureOldEnum,
	ThicknessEnum,
	ThicknessCoeffEnum,
	ThicknessObsEnum,
	TypeEnum,
	VelEnum,
	VelObsEnum,
	ViscosityOvershootEnum,
	VxAverageEnum,
	VxEnum,
	VxObsEnum,
	VxPicardEnum,
	QmuVxEnum,
	VyAverageEnum,
	VyEnum,
	VyObsEnum,
	VyPicardEnum,
	QmuVyEnum,
	VzAverageEnum,
	VzEnum,
	VzObsEnum,
	VzPicardEnum,
	VzMacAyealEnum,
	VzPattynEnum,
	VzStokesEnum,
	QmuVzEnum,
	WeightsEnum,
	/*}}}*/
	/*Element types{{{1*/
	P0Enum,
	P1Enum,
	P1DGEnum,
	MiniEnum,
	/*}}}*/
	/*Results{{{1*/
	DoubleElementResultEnum,
	TriaVertexElementResultEnum,
	PentaVertexElementResultEnum,
	BoolElementResultEnum,
	BoolExternalResultEnum,
	DoubleExternalResultEnum,
	DoubleVecExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	PetscVecExternalResultEnum,
	StringExternalResultEnum,
	JEnum,
	PatchEnum,
	PatchVerticesEnum,
	PatchNodesEnum,
	TimeEnum,
	OutputFrequencyEnum,
	Fake8Enum,
	WaterColumnOldEnum,
	Fake34Enum,
	/*}}}*/
	/*Io{{{1*/
	IoGatherEnum,
	/*}}}*/
	/*Responses{{{1*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	/*}}}*/
	/*Convergence{{{1*/
	RelativeEnum,
	ResidualEnum,
	AbsoluteEnum,
	IncrementalEnum,
	/*}}}*/
	/*Grounding Line{{{1*/
	NoneEnum,
	AgressiveMigrationEnum,
	SoftMigrationEnum,
	/*}}}*/
	/*Material{{{1*/
	RhoIceEnum,
	RhoWaterEnum,
	GravityEnum,
	Fake9Enum,
	BasalMeltingRateCorrectionEnum,
	MixedLayerCapacityEnum,
	ThermalExchangeVelocityEnum,
	/*}}}*/
	/*Solver{{{1*/
	StokesSolverEnum,
	/*}}}*/
	/*Parameters{{{1*/
	IntersectEnum,
	ColinearEnum,
	SeparateEnum,
	BetaEnum,
	CmGradientEnum,
	CmJumpEnum,
	CmMaxEnum,
	CmMinEnum,
	AdjointEnum,
	GradientEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	OldGradientEnum,
	ConnectivityEnum,
	ControlSteadyEnum,
	DakotaParameterEnum,
	DimEnum,
	EpsAbsEnum,
	EpsCmEnum,
	EpsRelEnum,
	EpsResEnum,
	Fake10Enum,
	Fake29Enum,
	Fake11Enum,
	Fake12Enum,
	Fake13Enum,
	Fake14Enum,
	LowmemEnum,
	Fake16Enum,
	MaxNonlinearIterationsEnum,
	Fake17Enum,
	MinMechanicalConstraintsEnum,
	MinThermalConstraintsEnum,
	Fake18Enum,
	NdtEnum,
	NumOutputEnum,
	NumriftsEnum,
	NumberOfElementsEnum,
	NumberOfNodesEnum,
	NumberOfVerticesEnum,
	Fake19Enum,
	OutputFilePointerEnum,
	Fake20Enum,
	Fake21Enum,
	Fake42Enum,
	QmuAnalysisEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuMassFluxSegmentsEnum,
	Fake39Enum,
	QmuOutNameEnum,
	QmuPartEnum,
	QmuNumberOfResponsesEnum,
	Fake43Enum,
	IndexedEnum,
	RegularEnum,
	IndexEnum,
	ScaledEnum,
	NodalEnum,
	ResponsedescriptorsEnum,
	PetscRcEnum,
	Fake40Enum,
	Fake22Enum,
	VariabledescriptorsEnum,
	VerboseEnum,
	Fake23Enum,
	PetscOptionsStringsEnum,
	PetscOptionsAnalysesEnum,
	GsetEnum,
	FsetEnum,
	SsetEnum,
	GroundinglineMigrationEnum,
	YtsEnum,
	/*}}}*/
	/*Interpolation {{{1*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Options{{{1*/
	OptionEnum,
	OptionCellEnum,
	OptionCharEnum,
	OptionDoubleEnum,
	OptionLogicalEnum,
	OptionStructEnum,
	/*}}}*/
	/*Rheology law (move too Material) {{{1*/
	RheologyLawEnum,
	PatersonEnum,
	ArrheniusEnum,
	/*}}}*/
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	Fake24Enum,
	Fake25Enum,
	Fake26Enum,
	EnthalpySolutionEnum,
	EnthalpyAnalysisEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	Fake27Enum,
	Fake28Enum,
	ThicknessAbsGradientEnum,
	VelAbsGradientEnum,
	DatasetInputEnum,
	Fake38Enum,
	StepResponsesEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	/*Temporary*/
	NumberOfElements2DEnum,
	NumControlTypeEnum,
	SpcvyEnum,
	HydroQEnum,
	VerboseBinaryEnum,
	NodeOnWaterEnum,
	YEnum,
	GlMeltingRateEnum,
	ElementsTypeEnum,
	PenaltiesEnum,
	PrognosticDGEnum,
	PressureloadEnum,
	HydroCREnum,
	NameEnum,
	VerticesTypeEnum,
	HydroKnEnum,
	GEnum,
	InputfilenameEnum,
	SpcvzEnum,
	Fake33Enum,
	NumberOfNodes2DEnum,
	NodeOnStokesEnum,
	NodeOnHutterEnum,
	ZEnum,
	Fake36Enum,
	RiftinfoEnum,
	ElementOnIceSheetEnum,
	SpcthicknessEnum,
	SpctemperatureEnum,
	PenaltyLockEnum,
	SpcvxEnum,
	UpperelementsEnum,
	HydroPEnum,
	NodeOnPattynEnum,
	EdgesEnum,
	Elements2DEnum,
	XEnum,
	NumCmResponsesEnum,
	NodeOnMacayealEnum,
	ElementconnectivityEnum,
	SpcwatercolumnEnum,
	ArtificialDiffusivityEnum,
	HydroNEnum,
	BorderstokesEnum,
	NumlayersEnum,
	DiagnosticRefEnum,
	IshutterEnum,
	IsmacayealpattynEnum,
	IsstokesEnum,
	StokesreconditioningEnum,
	LowerelementsEnum,
	HeatcapacityEnum,
	LatentheatEnum,
	ThermalconductivityEnum,
	MeltingpointEnum,
	ReferencetemperatureEnum,
	DhdtEnum,
	GeothermalfluxEnum,
	IsprognosticEnum,
	IsdiagnosticEnum,
	IsthermalEnum,
	NstepsEnum,
	MaxiterEnum,
	TolxEnum,
	OptscalEnum,
	EpsvelEnum,
	MeanvelEnum,
	Fake30Enum,
	OutputfilenameEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	WaitonlockEnum,
	NumberOfVariablesEnum,
	NumberOfResponsesEnum,
	NpartEnum,
	QmuMassFluxNumProfilesEnum,
	PartEnum,
	MaxSteadystateIterationsEnum,
	RequestedOutputsEnum,
	NumRequestedOutputsEnum,
	BasalFrictionEnum,
	ViscousHeatingEnum,
	QmuTemperatureEnum,
	QmuRheologyBEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	SpcDynamicEnum,
	NumberOfEdgesEnum,
	ResultsOnVerticesEnum,
	MaximumNumberOfEnums
};

/*Functions on enums: */
char *EnumToModelField(int  en);

#endif
