#!/bin/bash
#generate html report from nightly.log output file

#get some variables
function today_date {
suffix=`date | awk '{printf("%s-%s-%s %s",$2,$3,$6,$4);}'` 
echo $suffix;
}
ISSM_RELEASE="issm";
today=`today_date`;
host_name=`hostname`;

#Process log for errors 
cat nightly.log | grep 'package: macayeal'      | grep -v "not supported yet" > macayeal.log
cat nightly.log | grep 'package: ice'           | grep -v "not supported yet" > ice.log
cat nightly.log | grep 'package: cielo_serial'  | grep -v "not supported yet" > cielo_serial.log
cat nightly.log | grep 'package: cielo_parallel'| grep -v "not supported yet" > cielo_parallel.log
cat nightly.log | grep NIGHTLYRUNTERMINATEDCORRECTLY > check.log
cat nightly.log | grep ERROR | grep -v "PETSC ERROR" > errors.log
cat nightly.log | grep SUCCESS > success.log
cat errors.log success.log > tests.log
#mail -s "Nightly runs of $ISSM_RELEASE on: $host_name. Date:$today." mathieu.morlighem@jpl.nasa.gov < tests.log

#build report.html
cat <<END > report.html
<html>
<title>ISSM - Nightly run Report</title>
<body>

<style type="text/css">
	<!--
	.issmh1 {
		margin-top:1em;
		background: none;
		color: #6495ed;
		font-family: Arial, Verdana, Tahoma;
		font-size: 35px;
		font-weight: bold;
		text-align: center;
		}

	.issmh2 {
		margin-top:1.5em;
		width:800px;
		background: transparent;
		color: #6495ed;
		font-family: Arial, Verdana, Tahoma;
		font-weight: bold;
		font-size: 28px;
		text-align: left;
		}

	.issmcomment
		{white-space:pre-wrap;
		word-wrap:break-word;
		padding:4px;
		width:800px;
		border:1px dashed #000000;
		text-align: left;
		font-family: Arial, Verdana, Tahoma;
		font-size: 14px;
		color: #404040;
		background-color:#ffffdd}
	-->
</style>
<div align="center" style=" font-family:Arial,Verdana,Tahoma; font-size: 14px; color: #404040;">
<br>
<pre class="issmh1">ISSM Nightly run report</pre>
<br>
<pre class="issmcomment">
host: $host_name
date: $today
release: $ISSM_RELEASE

status: $(if [ `wc -l check.log | awk '{printf("%s",$1);}'`  = "0" ];
then
	echo "<span style=\"color:#FF0000\">stopped before the end</span>"
else
	echo "all test desks have been run"
fi
rm check.log) 
number of errors: $(wc -l errors.log | awk '{printf("%s",$1);}')/$(wc -l tests.log | awk '{printf("%s",$1);}';  rm errors.log)
number of success: $(wc -l success.log | awk '{printf("%s",$1);}')/$(wc -l tests.log | awk '{printf("%s",$1);}';rm success.log tests.log)</pre>
<br>
<hr width="900px">

$(for  package in "macayeal" "ice" "cielo_serial" "cielo_parallel"; do

	#enter title
	if [ $package == "macayeal" ]; then
		echo "<pre class=\"issmh2\">MacAyeal package</pre>"
	fi
	if [ $package == "ice" ]; then
		echo "<pre class=\"issmh2\">Ice package</pre>"
	fi
	if [ $package == "cielo_serial" ]; then
		echo "<pre class=\"issmh2\">Cielo Serial package</pre>"
	fi
	if [ $package == "cielo_parallel" ]; then
		echo "<pre class=\"issmh2\">Cielo Parallel package</pre>"
	fi

	#check that at least one test exists
	if [ `wc -l $package.log | awk '{printf("%s",$1);}'`  = "0" ]; then
		echo "&nbsp;&nbsp No test found."
	else

		echo "<table cellspacing=\"-1\" width=\"800px\" style=\"font-family: Arial, Verdana, Tahoma; color: #404040;\">"
		echo "<tr> <th style=\"font-size:14px;\">Result</th> <th style=\"font-size:14px;\">Tolerance</th> <th style=\"font-size:14px;\">Test</th>  <th style=\"font-size:14px;\">Solution</th> <th style=\"font-size:14px;\">Field</th> </tr>"

		# go through the lines of $package.log
		for i in $(seq 1 1 `wc -l $package.log | awk '{printf("%s",$1);}'`); do 

			echo "<tr>"

			#see wether it is success or error (get color: red or green)
			if [ "`cat $package.log | awk '{ printf "line%so %s\n", NR, $0 }' | awk '/line'$i'o/ {printf("%s\n",$2);}';`" == "SUCCESS" ];  
			then 
				color="bgcolor=#ddffdd";
			else
				color="bgcolor=#ffdddd";
			fi

			#build html corresponding line
			cat $package.log | awk '{ printf "line%so %s\n", NR, $0 }' | awk '/line'$i'o/ {printf("<td '$color' style=\"font-size:14px;\">%s</td><td '$color' style=\"font-size:14px;\"> %s%s%s</td><td '$color' style=\"font-size:14px;\"> %s</td><td '$color' style=\"font-size:14px;\"> %s</td><td '$color' style=\"font-size:14px;\"> %s</td>",$2,$4,$5,$6,$8,$10,$14);}';
			echo "</tr>"
		done

		echo "</table>"
	fi
	rm $package.log
done)

	<br>
	<br>
	<center><small></a><a href="http://issm.jpl.nasa.gov" title="ISSM website" target="_blank">ISSM</a> nightly run report</small></center>
	</div>
	</body>
	</html>
END
