function md=issm(md,solution_type);
%ISSM - ISSM main parallel program
%
%   Usage:
%      md=issm(md)
%
	%timing
	t1=clock;
	disp('launching solution sequence');

	%out of solution_type, figure out solution core function pointer, and types of analyses needed:
	[analyses,numanalyses,solutioncore]=SolutionConfiguration(solution_type);

	%create finite element model
	femmodel=NewFemModel(md,solution_type,analyses,numanalyses);
	
	%process petsc options: 
	femmodel.parameters=ParsePetscOptions(femmodel.parameters,[md.name '.petsc']);

	%retrieve parameters
	qmu_analysis=femmodel.parameters.QmuAnalysis;
	control_analysis=femmodel.parameters.ControlAnalysis;

	%if control being run on top of solution, change core
	if(control_analysis)solutioncore='control_core';end

	%compute solution
	if ~qmu_analysis,
			
		issmprintf(VerboseSolution,'%s',['call computational core']);
		eval(['femmodel=' solutioncore '(femmodel);']);

		issmprintf(VerboseSolution,'%s',['write results'])
		md.results.(EnumToString(solution_type))=OutputResults(femmodel.elements, femmodel.nodes , femmodel.vertices , femmodel.loads , femmodel.materials, femmodel.parameters, femmodel.results);
	else
		%launch dakota driver for diagnostic core solution
		display('calling Qmu');
		Qmu(femmodel,femmodel.parameters);
		display('finished with Qmu');
	end

	dtest=Response(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,'MinVx',true);
	disp(sprintf('MinVx=%g\n',dtest));
	dtest=Response(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,'MaxVx',true);
	disp(sprintf('MaxVx=%g\n',dtest));
	dtest=Response(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,'MaxAbsVx',true);
	disp(sprintf('MaxAbsVx=%g\n',dtest));
	dtest=Response(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,'MinVy',true);
	disp(sprintf('MinVy=%g\n',dtest));
	dtest=Response(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,'MaxVy',true);
	disp(sprintf('MaxVy=%g\n',dtest));
	dtest=Response(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,'MaxAbsVy',true);
	disp(sprintf('MaxAbsVy=%g\n',dtest));
%	dtest=Response(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,'MinVel',true);
%	disp(sprintf('MinVel=%g\n',dtest));
%	dtest=Response(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,'MaxVel',true);
%	disp(sprintf('MaxVel=%g\n',dtest));

	%stop timing
	t2=clock;
	disp(['solution converged in ' num2str(etime(t2,t1)) ' seconds']);

	display('writing femmodel to femmodel.mat');
	save femmodel femmodel

