function md=SetIceSheetBC(md)
%SETICESHEETBC - Create the boundary conditions for diagnostic and thermal models for an IceSheet with no Ice Front
%
%   Usage:
%      md=SetIceSheetBC(md)
%
%   See also: SETICESHELFBC, SETMARINEICESHEETBC

%node on Dirichlet
pos=find(md.nodeonboundary);
md.spcvx=NaN*ones(md.numberofnodes,1);
md.spcvy=NaN*ones(md.numberofnodes,1);
md.spcvz=NaN*ones(md.numberofnodes,1);
md.spcvx(pos)=0;
md.spcvy(pos)=0;
md.spcvz(pos)=0;
md.diagnostic_ref=NaN*ones(md.numberofnodes,6);

%Dirichlet Values
if (length(md.vx_obs)==md.numberofnodes & length(md.vy_obs)==md.numberofnodes)
	disp('      boundary conditions for diagnostic model: spc set as observed velocities');
	md.spcvx(pos)=md.vx_obs(pos);
	md.spcvy(pos)=md.vy_obs(pos);
else
	disp('      boundary conditions for diagnostic model: spc set as zero');
end

%segment on neumann (Ice Front) -> none
if (md.dim==2)
	md.pressureload=zeros(0,4);
else
	md.pressureload=zeros(0,6);
end

%Create zeros basal_melting_rate and surface mass balance if not specified
if isnan(md.surface_accumulation_rate),
	md.surface_accumulation_rate=zeros(md.numberofnodes,1);
	md.forcings.surface_accumulation_rate=zeros(md.numberofnodes+1,1);
	disp('      no surface_accumulation_rate specified: values set as zero');
end
if isnan(md.surface_ablation_rate),
	md.surface_ablation_rate=zeros(md.numberofnodes,1);
	md.forcings.surface_ablation_rate=zeros(md.numberofnodes+1,1);
	disp('      no surface_ablation_rate specified: values set as zero');
end
if isnan(md.surface_mass_balance),
	md.surface_mass_balance=zeros(md.numberofnodes,1);
	md.forcings.surface_mass_balance=zeros(md.numberofnodes+1,1);
	disp('      no surface_mass_balance specified: values set as zero');
end
if isnan(md.basal_melting_rate),
	md.basal_melting_rate=zeros(md.numberofnodes,1);
	disp('      no basal_melting_rate specified: values set as zero');
end
if isnan(md.dhdt),
	md.dhdt=zeros(md.numberofnodes,1);
	disp('      no dhdt specified: values set as zero');
end

md.spcthickness=NaN*ones(md.numberofnodes,1);

if (length(md.observed_temperature)==md.numberofnodes),
	md.spctemperature=NaN*ones(md.numberofnodes,1);
	pos=find(md.nodeonsurface); md.spctemperature(pos)=md.observed_temperature(pos); %impose observed temperature on surface
	if (length(md.geothermalflux)~=md.numberofnodes),
		md.geothermalflux=50*10^-3*ones(md.numberofnodes,1); %50 mW/m^2
	end
else
	disp('      no thermal boundary conditions created: no observed temperature found');
end
