/*
 * UpdateElementsMelting:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsMelting(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	int    dim;
	int    numberofelements;

	/*Fetch parameters: */
	iomodel->Constant(&dim,DimEnum);
	iomodel->Constant(&numberofelements,NumberOfElementsEnum);

	/*Now, is the model 3d? otherwise, do nothing: */
	if (dim==2)return;

	/*Fetch data needed: */
	iomodel->FetchData(1,ElementsEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	/*Create inputs: */
	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,SurfaceEnum);
	iomodel->FetchDataToInput(elements,BedEnum);
	iomodel->FetchDataToInput(elements,DragCoefficientEnum);
	iomodel->FetchDataToInput(elements,DragPEnum);
	iomodel->FetchDataToInput(elements,DragQEnum);
	iomodel->FetchDataToInput(elements,ElementOnIceShelfEnum);
	iomodel->FetchDataToInput(elements,ElementOnBedEnum);
	iomodel->FetchDataToInput(elements,ElementOnSurfaceEnum);
	iomodel->FetchDataToInput(elements,ElementOnWaterEnum);
	iomodel->FetchDataToInput(elements,ElementsTypeEnum);
	iomodel->FetchDataToInput(elements,RheologyBEnum);
	iomodel->FetchDataToInput(elements,RheologyNEnum);
	iomodel->FetchDataToInput(elements,SurfaceAccumulationRateEnum);
	iomodel->FetchDataToInput(elements,SurfaceAblationRateEnum);
	iomodel->FetchDataToInput(elements,SurfaceMassBalanceEnum);
	iomodel->FetchDataToInput(elements,BasalMeltingRateEnum);
	iomodel->FetchDataToInput(elements,PressureEnum);
	
	/*Free data: */
	iomodel->DeleteData(1,ElementsEnum);
}
