function displaytransient(md)
%DISPLAYTRANSIENT - display solution parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays the solution parameters
%   from model md, only if requested.
%
%   Usage:
%      displaytransient(md)

disp('Transient parameters on a pure solution basis:');
if md.isdiagnostic,
	displaydiagnostic(md);
else
	disp(sprintf('         %s','no scheduled diagnostic. activate by doing md.isdiagnostic=1'));
end
if md.isprognostic,
	displayprognostic(md);
else
	disp(sprintf('         %s','no scheduled prognostic. activate by doing md.isprognostic=1'));
end
if md.isthermal,
	displaythermal(md);
else
	disp(sprintf('         %s','no scheduled thermal. activate by doing md.isthermal=1'));
end

disp(sprintf('   Transient solution parameters:\n'));

fielddisplay(md,'deltaH','minimum thickness difference between two time steps');
fielddisplay(md,'DeltaH','maximum thickness difference between two time steps');
fielddisplay(md,'deltaT','minimum temperature difference between two time steps');
fielddisplay(md,'DeltaT','maximum temperature difference between two time steps');
fielddisplay(md,'timeacc','multiplier to time step when time stepping increases time step');
fielddisplay(md,'timedec','multiplier to time step when time stepping decresaes time step');
fielddisplay(md,'time_adapt','compute new time step each iteration, using CFL criterion');
fielddisplay(md,'cfl_coefficient','CFL coefficient');
fielddisplay(md,'hydrostatic_adjustment','type of adjustment for ice shelves update');
fielddisplay(md,'groundingline_migration','type of adjustment for grounding line');
