function md=tres(md,string)
%TRES - transfer results results to corresponding model fields. 
%
%    Usage: md=tres(md,string)
%
%    Example: md=tres(md,'diagnostic');

%check number of arguments

if strcmpi(string,'diagnostic'),
	if md.dim==2,
		if isfield(md.results.DiagnosticSolution,'VxAverage'),
			md.vx=PatchToVec(md.results.DiagnosticSolution.VxAverage);
		else
			md.vx=PatchToVec(md.results.DiagnosticSolution.Vx);
		end
		if isfield(md.results.DiagnosticSolution,'VyAverage'),
			md.vy=PatchToVec(md.results.DiagnosticSolution.VyAverage);
		else
			md.vy=PatchToVec(md.results.DiagnosticSolution.Vy);
		end
	else 
		md.vx=PatchToVec(md.results.DiagnosticSolution.Vx);
		md.vy=PatchToVec(md.results.DiagnosticSolution.Vy);
		if isfield(md.results.DiagnosticSolution,'Vz'),
			md.vz=PatchToVec(md.results.DiagnosticSolution.Vz);
		else
			md.vz=zeros(md.numberofnodes,1);
		end
	end
	md.vel=PatchToVec(md.results.DiagnosticSolution.Vel);

	if isfield(md.results.DiagnosticSolution,'Pressure'),
		md.pressure=PatchToVec(md.results.DiagnosticSolution.Pressure);
	end
	if md.numrifts,
		if isfield(md.results.DiagnosticSolution,'riftproperties'),
			md.riftproperties=md.results.DiagnosticSolution.riftproperties;
		end
	end
	if md.control_analysis==1,
		for control_type=md.control_type
			md.(EnumToModelField(control_type))=PatchToVec(md.results.DiagnosticSolution.(EnumToString(control_type)));
		end
	end

elseif strcmpi(string,'dakota'),
	md.dakotaresults=md.results.dakota;

elseif strcmpi(string,'flaim'),
	md.fm_solution=md.results.FlaimSolution.solution;
	md.fm_quality =md.results.FlaimSolution.quality;

elseif strcmpi(string,'transient'),
	results=md.results.TransientSolution;
	results2.Vel=NaN;
	count=1;
	for i=1:length(results),
		if ~isempty(md.results.TransientSolution(i).Vel),
			results2(count).Vel=PatchToVec(md.results.TransientSolution(i).Vel);
			results2(count).Surface=PatchToVec(md.results.TransientSolution(i).Surface);
			results2(count).Thickness=PatchToVec(md.results.TransientSolution(i).Thickness);
			results2(count).Bed=PatchToVec(md.results.TransientSolution(i).Bed);
			results2(count).Vx=PatchToVec(md.results.TransientSolution(i).Vx);
			results2(count).Vy=PatchToVec(md.results.TransientSolution(i).Vy);
			results2(count).time=md.results.TransientSolution(i).time;
			results2(count).step=md.results.TransientSolution(i).step;
			if md.groundingline_migration~=NoneEnum,
				results2(count).ElementOnIceShelf=md.results.TransientSolution(i).ElementOnIceShelf;
			end
			count=count+1;
		end
	end
	md.results.TransientSolution=results2;
	clear results,results2;
elseif strcmpi(string,'steadystate'),
	md.vx=PatchToVec(md.results.SteadystateSolution.Vx);
	md.vy=PatchToVec(md.results.SteadystateSolution.Vy);
	if isfield(md.results.SteadystateSolution,'Vz'),
		md.vz=PatchToVec(md.results.SteadystateSolution.Vz);
	end

	md.vel=PatchToVec(md.results.SteadystateSolution.Vel);
	md.pressure=PatchToVec(md.results.SteadystateSolution.Pressure);
	md.temperature=PatchToVec(md.results.SteadystateSolution.Temperature);
	md.basal_melting_rate=PatchToVec(md.results.SteadystateSolution.BasalMeltingRate);

	if md.control_analysis==1,
		for control_type=md.control_type
			md.(EnumToModelField(control_type))=PatchToVec(md.results.SteadystateSolution.(EnumToString(control_type)));
		end
	end

elseif strcmpi(string,'thermal'),
	md.temperature=PatchToVec(md.results.ThermalSolution.Temperature);
	md.basal_melting_rate=PatchToVec(md.results.ThermalSolution.BasalMeltingRate);
elseif strcmpi(string,'hydrology'),
	md.watercolumn=PatchToVec(md.results.HydrologySolution.Watercolumn);

else 
	error(['tres error message: analysis ' string ' not supported yet!']);
end
