function md=thermal(md)
%THERMAL - thermal solution sequence: steady state and transient
%
%   Usage:
%      md=thermal(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	displaystring(md.debug,'%s',['reading thermal model data']);
	md.analysis_type='thermal'; models.t=CreateFemModel(md);

	displaystring(md.debug,'%s',['reading melting model data']);
	md.analysis_type='melting'; models.m=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%initialize inputs
	displaystring(md.debug,'\n%s',['setup inputs...']);
	inputs=inputlist;
	inputs=add(inputs,'velocity',models.t.parameters.u_g,'doublevec',3,models.t.parameters.numberofnodes);
	inputs=add(inputs,'pressure',models.t.parameters.p_g,'doublevec',1,models.t.parameters.numberofnodes);
	inputs=add(inputs,'dt',models.t.parameters.dt,'double');
	models.t.parameters
	
	%call core
	results=thermal_core(models,inputs,md.sub_analysis_type);

	%plug onto the model
	if ~isstruct(md.results), md.results=struct(); end
	md.results.thermal=results;

	%stop timing
	t2=clock;
	displaystring(md.debug,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
