/*
 * CreateNodesDiagnosticHoriz.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHoriz(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	int i;
	bool   continuous_galerkin=true;
	int    numberofvertices;
	bool   isstokes,ismacayealpattyn;

	/*DataSets: */
	Nodes*    nodes = NULL;

	/*Fetch parameters: */
	printf("-------------- file: CreateNodesDiagnosticHoriz.cpp line: %i\n",__LINE__); 
	iomodel->constants->FindParam(&numberofvertices,NumberOfVerticesEnum);
	printf("-------------- file: CreateNodesDiagnosticHoriz.cpp line: %i\n",__LINE__); 
	iomodel->constants->FindParam(&isstokes,IsstokesEnum);
	printf("-------------- file: CreateNodesDiagnosticHoriz.cpp line: %i\n",__LINE__); 
	iomodel->constants->FindParam(&ismacayealpattyn,IsmacayealpattynEnum);
	printf("-------------- file: CreateNodesDiagnosticHoriz.cpp line: %i\n",__LINE__); 

	/*Recover pointer: */
	nodes=*pnodes;

	/*First create nodes*/
	if(!nodes) nodes = new Nodes(NodesEnum);
	
	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if(!ismacayealpattyn & !isstokes){
		*pnodes=nodes;
		return;
	}

	/*Continuous Galerkin partition of nodes: */
	printf("-------------- file: CreateNodesDiagnosticHoriz.cpp line: %i\n",__LINE__); 
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,continuous_galerkin);
	printf("-------------- file: CreateNodesDiagnosticHoriz.cpp line: %i\n",__LINE__); 

	/*Create nodes: */
	iomodel->FetchData(10,NodeOnBedEnum,NodeOnSurfaceEnum,NodeOnHutterEnum,NodeOnMacayealEnum,NodeOnStokesEnum,
				NodeOnIceSheetEnum,NodeOnIceShelfEnum,NodeOnWaterEnum,VerticesTypeEnum,DiagnosticRefEnum);
	printf("-------------- file: CreateNodesDiagnosticHoriz.cpp line: %i\n",__LINE__); 
	
	for (i=0;i<numberofvertices;i++){

		if(iomodel->my_vertices[i]){
			
			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,DiagnosticHorizAnalysisEnum));
		}
	}

	/*Clean fetched data: */
	iomodel->DeleteData(10,NodeOnBedEnum,NodeOnSurfaceEnum,NodeOnHutterEnum,NodeOnMacayealEnum,NodeOnStokesEnum,
				NodeOnIceSheetEnum,NodeOnIceShelfEnum,NodeOnWaterEnum,VerticesTypeEnum,DiagnosticRefEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
