/*
 * UpdateElementsPrognostic:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsPrognostic(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	int    dim;
	int    numberofelements;
	int    prognostic_DG;

	/*Fetch data needed: */
	iomodel->constants->FindParam(&dim,DimEnum);
	iomodel->constants->FindParam(&numberofelements,NumberOfElementsEnum);
	iomodel->constants->FindParam(&prognostic_DG,PrognosticDGEnum);
	iomodel->FetchData(1,ElementsEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,SurfaceEnum);
	iomodel->FetchDataToInput(elements,BedEnum);
	iomodel->FetchDataToInput(elements,ElementOnIceShelfEnum);
	iomodel->FetchDataToInput(elements,ElementOnWaterEnum);
	iomodel->FetchDataToInput(elements,SurfaceAccumulationRateEnum);
	iomodel->FetchDataToInput(elements,SurfaceAblationRateEnum);
	iomodel->FetchDataToInput(elements,SurfaceMassBalanceEnum);
	iomodel->FetchDataToInput(elements,BasalMeltingRateEnum);
	iomodel->FetchDataToInput(elements,BasalMeltingRateCorrectionEnum);
	iomodel->FetchDataToInput(elements,VxEnum);
	iomodel->FetchDataToInput(elements,VyEnum);

	if(prognostic_DG){
		iomodel->FetchDataToInput(elements,SpcthicknessEnum); //for DG, we need the spc in the element
	}
	
	if (dim==3){
		iomodel->FetchDataToInput(elements,ElementOnBedEnum);
		iomodel->FetchDataToInput(elements,ElementOnSurfaceEnum);
		iomodel->FetchDataToInput(elements,PressureEnum);
		iomodel->FetchDataToInput(elements,TemperatureEnum);
	}
	
	/*Free data: */
	iomodel->DeleteData(1,ElementsEnum);
}
