/* \file IoModel.h
 * \brief  Header file defining the IoModel structure that will help in processing the input data coming 
 * into ISSM, from Matlab, or through a binary file opened for reading.
 * \sa IoModel.cpp
 */

#ifndef _IOMODEL_H
#define _IOMODEL_H

#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

class Elements;


class IoModel {

	private: 
		FILE* fid; //pointer to input file

	public:
		Parameters *constants;   //this dataset holds all double, int, bool and char*parameters read in from the input file.*
		Parameters *data;        //this dataset holds temporary data, memory intensive.

		/*This data needs to stay memory resident at all time, even if it's memory intensive: */
		bool *my_elements;
		bool *my_nodes;
		int  *my_vertices;
		int  *singlenodetoelementconnectivity;
		int  *numbernodetoelementconnectivity;

		/*Data to synchronize through low level object drivers: */
		int nodecounter;         //keep track of how many nodes are being created in each analysis type
		int loadcounter;         //keep track of how many loads are being created in each analysis type
		int constraintcounter;   //keep track of how many constraints are being created in each analysis type

		/*Methods: {{{1*/
		~IoModel();
		IoModel();
		IoModel(FILE* iomodel_handle);
		/*}}}*/
		/*Input/Output:{{{1*/
		void  FetchData(bool*     pboolean,int data_enum);
		void  FetchData(int*      pinteger,int data_enum);
		void  FetchData(double*   pscalar,int data_enum);
		void  FetchData(char**    pstring,int data_enum);
		void  FetchData(int** pmatrix,int* pM,int* pN,int data_enum);
		void  FetchData(double**  pscalarmatrix,int* pM,int* pN,int data_enum);
		void  FetchData(char***   pstringarray,int* pnumstrings,int data_enum);
		void  FetchData(double*** pmatrixarray,int** pmdims,int** pndims, int* pnumrecords,int data_enum);
		void  FetchParameters(Parameters* parameters);
		FILE* SetFilePointerToData(int* pcode,int* pvector_type, int data_enum);
		void  FetchDataToInput(Elements* elements,int vector_enum,int default_vector_enum=NoneEnum,double default_value=0);
		void  FetchData(int num,...);
		double* f(int dataenum);
		void  DeleteData(int num,...);
		/*}}}*/

};

#endif  /* _IOMODEL_H */
