#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "VertexOnGeom.h"
#include "Mesh.h"
#include "Geometry.h"

namespace bamg {

	/*Constructors/Destructors*/
	/*FUNCTION VertexOnGeom::VertexOnGeom(){{{1*/
	VertexOnGeom::VertexOnGeom(){
		meshvertex=NULL;
		curvilincoord=0;
		gv=0;
		//ge=0;
	} 
	/*}}}*/
	/*FUNCTION VertexOnGeom::VertexOnGeom(BamgVertex & m,GeomVertex &g){{{1*/
	VertexOnGeom::VertexOnGeom(BamgVertex & m,GeomVertex &g){
		meshvertex=&m;
		curvilincoord=-1;
		gv=&g;
		//ge=0;
	}
	/*}}}*/
	/*FUNCTION VertexOnGeom::VertexOnGeom(BamgVertex & m,GeomEdge &g,double s){{{1*/
	VertexOnGeom::VertexOnGeom(BamgVertex & m,GeomEdge &g,double s){
		meshvertex=&m;
		curvilincoord=s;
		ge=&g;
		//gv=0;
	}
	/*}}}*/

	/*Methods*/
	/*FUNCTION VertexOnGeom::Set {{{1*/
	void VertexOnGeom::Set(const VertexOnGeom & rec,const Mesh & Th ,Mesh & ThNew){
		*this = rec;  
		meshvertex = ThNew.vertices + Th.GetId(meshvertex);
		if (gv)
		 if (curvilincoord < 0 )
		  gv = ThNew.Gh.vertices + Th.Gh.GetId(gv);
		 else
		  ge = ThNew.Gh.edges + Th.Gh.GetId(ge);

	}
	/*}}}*/
	/*FUNCTION VertexOnGeom::OnGeomVertex{{{1*/
	int VertexOnGeom::OnGeomVertex()const{
		return this? curvilincoord <0 :0;
	}
	/*}}}*/
	/*FUNCTION VertexOnGeom::OnGeomEdge{{{1*/
	int VertexOnGeom::OnGeomEdge() const{
		return this? curvilincoord >=0 :0;
	}
	/*}}}*/
	/*FUNCTION VertexOnGeom::IsRequiredVertex{{{1*/
	int VertexOnGeom::IsRequiredVertex() {
		return this? ((curvilincoord<0 ? (gv?gv->Required():0):0 )) : 0;
	}
	/*}}}*/
	/*FUNCTION VertexOnGeom::SetOn{{{1*/
	void VertexOnGeom::SetOn(){
		meshvertex->GeomEdgeHook=this;
		meshvertex->IndexInTriangle=IsVertexOnGeom;
	}
	/*}}}*/

} 
