function md=prognostic(md)
%PROGNOSITC - prognostic solution sequence.
%
%   Usage:
%      md=prognostic(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	displaystring(md.debug,'%s',['reading prognostic model data']);
	md.analysis_type='prognostic'; models.p=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=models.p.nodesets.fsize;

	%initialize inputs
	displaystring(md.debug,'\n%s',['setup inputs...']);
	inputs=inputlist;
	inputs=add(inputs,'velocity',models.p.parameters.u_g,'doublevec',3,models.p.parameters.numberofnodes);
	inputs=add(inputs,'thickness',models.p.parameters.h_g,'doublevec',1,models.p.parameters.numberofnodes);
	inputs=add(inputs,'melting',models.p.parameters.m_g,'doublevec',1,models.p.parameters.numberofnodes);
	inputs=add(inputs,'accumulation',models.p.parameters.a_g,'doublevec',1,models.p.parameters.numberofnodes);
	inputs=add(inputs,'dt',models.p.parameters.dt,'double');

	displaystring(md.debug,'\n%s',['call computational core:']);
	rawresults=prognostic_core(models,inputs,'prognostic','');

	displaystring(md.debug,'\n%s',['load results...']);
	if ~isstruct(md.results), md.results=struct(); end
	md.results.prognostic.step=1;
	md.results.prognostic.time=0;
	md.results.prognostic.thickness=rawresults.h_g;

	%stop timing
	t2=clock;
	displaystring(md.debug,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
