/*! \file CreateLoadsThermal.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsThermal(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int i;
	int    dim;
	int    numberofvertices;

	/*DataSet*/
	Loads*    loads    = NULL;
	Pengrid*    pengrid  = NULL;

	/*Recover pointer: */
	loads=*ploads;

	/*Fetch parameters: */
	iomodel->constants->FindParam(&dim,DimEnum);
	iomodel->constants->FindParam(&numberofvertices,NumberOfVerticesEnum);

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads(LoadsEnum);

	/*return if 2d mesh*/
	if (dim==2) _error_("2d meshes not supported yet");

	//create penalties for nodes: no node can have a temperature over the melting point
	iomodel->FetchData(&iomodel->spctemperature,NULL,NULL,SpctemperatureEnum);
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);
	CreateSingleNodeToElementConnectivity(iomodel);

	for (i=0;i<numberofvertices;i++){
	
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if (isnan(iomodel->spctemperature[i])){ //No penalty applied on spc nodes!

				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,ThermalAnalysisEnum));
						
			}
		}
	}
	xfree((void**)&iomodel->spctemperature);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->singlenodetoelementconnectivity);

	/*Assign output pointer: */
	*ploads=loads;
}
