/*! \file CreateLoadsMelting.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsMelting(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int i;
	int    dim;
	int    numberofvertices;

	/*DataSet*/
	Loads*    loads    = NULL;

	/*Fetch parameters: */
	iomodel->constants->FindParam(&dim,DimEnum);
	iomodel->constants->FindParam(&numberofvertices,NumberOfVerticesEnum);

	/*if 2d: Error*/
	if (dim==2) _error_("2d meshes not supported yet");

	/*Recover pointer: */
	loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads(LoadsEnum);

	//create penalties for nodes: no node can have a temperature over the melting point
	iomodel->FetchData(&iomodel->nodeonbed,NULL,NULL,NodeOnBedEnum);
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);
	CreateSingleNodeToElementConnectivity(iomodel);

	for (i=0;i<numberofvertices;i++){
		
		if((iomodel->my_vertices[i]==1)){

			if (iomodel->nodeonbed[i]){ 
				
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,MeltingAnalysisEnum));
			}
		}
	}
	xfree((void**)&iomodel->nodeonbed);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->singlenodetoelementconnectivity);

	/*Assign output pointer: */
	*ploads=loads;
}
