/*
 * CreateConstraintsEnthalpy.c:
 */

#include "../../../Container/Container.h"
#include "../../../io/io.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsEnthalpy(Constraints** pconstraints, IoModel* iomodel){

	/*Intermediary*/
	int i;
	int count;
	int    dim;
	int    numberofvertices;
	double heatcapacity;
	double referencetemperature;
	
	/*Output*/
	Constraints* constraints = NULL;
	SpcStatic*    spcstatic  = NULL;

	/*Fetch parameters: */
	iomodel->constants->FindParam(&dim,DimEnum);
	iomodel->constants->FindParam(&numberofvertices,NumberOfVerticesEnum);
	iomodel->constants->FindParam(&heatcapacity,HeatcapacityEnum);
	iomodel->constants->FindParam(&referencetemperature,ReferencetemperatureEnum);

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*return if 2d mesh*/
	if (dim==2) goto cleanup_and_return;

	/*Fetch data: */
	iomodel->FetchData(&iomodel->spctemperature,NULL,NULL,SpctemperatureEnum);

	/*Initialize counter*/
	count=0;

	/*Create constraints from x,y,z: */
	for (i=0;i<numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i])){

			if ((int)iomodel->spctemperature[2*i]){

				constraints->AddObject(new SpcStatic(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,heatcapacity*(iomodel->spctemperature[2*i+1]-referencetemperature),EnthalpyAnalysisEnum));
				count++;

			}
		}
	}

	/*Free data: */
	xfree((void**)&iomodel->spctemperature);

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
