/*
 * CreateConstraintsDiagnosticHoriz.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsDiagnosticVert(Constraints** pconstraints, IoModel* iomodel){

	/*Intermediary*/
	int i;
	int dim;
	int count;
	double yts;
	int    numberofvertices;

	/*Output*/
	Constraints* constraints = NULL;

	/*Fetch parameters: */
	iomodel->constants->FindParam(&dim,DimEnum);
	iomodel->constants->FindParam(&yts,YtsEnum);

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*return if 2d mesh*/
	if (dim==2) goto cleanup_and_return;

	/*Fetch data: */
	iomodel->FetchData(&iomodel->spcvz,NULL,NULL,SpcvzEnum);
	iomodel->FetchData(&iomodel->nodeonstokes,NULL,NULL,NodeOnStokesEnum);
	iomodel->constants->FindParam(&numberofvertices,NumberOfVerticesEnum);

	/*Initialize counter*/
	count=0;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<numberofvertices;i++){

		/*keep only this partition's nodes:*/
		if(iomodel->my_vertices[i]){

			if ((int)iomodel->nodeonstokes[i]){
				constraints->AddObject(new SpcStatic(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,0,DiagnosticVertAnalysisEnum)); //spc to zero as vertical velocity is done in Horiz for Stokes
				count++;
			}
			else if (!isnan(iomodel->spcvz[i])){
				constraints->AddObject(new SpcStatic(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,
								iomodel->spcvz[i]/yts,DiagnosticVertAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
				count++;

			}
		} 
	}

	/*Free data: */
	xfree((void**)&iomodel->spcvz);
	xfree((void**)&iomodel->nodeonstokes);

	cleanup_and_return:

	/*Assign output pointer: */
	*pconstraints=constraints;
}
