/*
 * CreateConstraintsDiagnosticHutter.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsDiagnosticHutter(Constraints** pconstraints, IoModel* iomodel){

	/*Intermediary*/
	int i;
	int count;
	double yts;
	int    numberofvertices;
	bool   ishutter;

	/*Output*/
	Constraints* constraints = NULL;
	SpcStatic*    spcstatic  = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Fetch parameters: */
	iomodel->constants->FindParam(&yts,YtsEnum);
	iomodel->constants->FindParam(&numberofvertices,NumberOfVerticesEnum);
	iomodel->constants->FindParam(&ishutter,IshutterEnum);

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!ishutter) goto cleanup_and_return;

	/*Fetch data: */
	iomodel->FetchData(&iomodel->spcvx,NULL,NULL,SpcvxEnum);
	iomodel->FetchData(&iomodel->spcvy,NULL,NULL,SpcvyEnum);
	iomodel->FetchData(&iomodel->nodeonhutter,NULL,NULL,NodeOnHutterEnum);

	/*Initialize conunter*/
	count=0;

	/*vx and vy are spc'd if we are not on nodeonhutter: */
	for (i=0;i<numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i])){
			if (!(int)iomodel->nodeonhutter[i]){

				constraints->AddObject(new SpcStatic(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,0,DiagnosticHutterAnalysisEnum));
				count++;

				constraints->AddObject(new SpcStatic(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,0,DiagnosticHutterAnalysisEnum));
				count++;
			}
			else{
				if (!isnan(iomodel->spcvx[i])){
					constraints->AddObject(new SpcStatic(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,iomodel->spcvx[i]/yts,DiagnosticHutterAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
					count++;
				}

				if (!isnan(iomodel->spcvy[i])){
					constraints->AddObject(new SpcStatic(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,iomodel->spcvy[i]/yts,DiagnosticHutterAnalysisEnum)); //add count'th spc, on node i+1, setting dof 2 to vy
					count++;
				}
			}
		} //if((my_vertices[i]))
	}

	/*Free data: */
	xfree((void**)&iomodel->nodeonhutter);
	xfree((void**)&iomodel->spcvx);
	xfree((void**)&iomodel->spcvy);

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
