/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#include "../../Container/Container.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "../../io/io.h"
#include "./ModelProcessorx.h"

void CreateParameters(Parameters** pparameters,IoModel* iomodel,const int solution_type,int analysis_type,int analysis_counter){
	
	int i;
	
	Parameters* parameters = NULL;

	double*     requestedoutputs=NULL;
	int      numoutputs=0;
	
	if(*pparameters)return; //do not create parameters twice!
		
	/*Initialize dataset: */
	parameters = (Parameters*)iomodel->constants->Copy();

	/*some parameters that did not come with the iomodel: */
	parameters->AddObject(new IntParam(SolutionTypeEnum,solution_type));
	parameters->AddObject(new IntParam(AnalysisTypeEnum,analysis_type));
	parameters->AddObject(new IntParam(AnalysisCounterEnum,analysis_counter));

	parameters->AddObject(new DoubleParam(TimeEnum,0.0));  //start at time 0 by default for all solutions.

	/*Requested output?*/
	iomodel->FetchData(&requestedoutputs,&numoutputs,NULL,RequestedOutputsEnum);
	parameters->AddObject(new IntParam(NumRequestedOutputsEnum,numoutputs));
	if(numoutputs)parameters->AddObject(new IntVecParam(RequestedOutputsEnum,requestedoutputs,numoutputs));
	xfree((void**)&requestedoutputs);
	
	/*Before returning, create parameters in case we are running Qmu or control types runs: */
	CreateParametersControl(&parameters,iomodel,solution_type,analysis_type);
	CreateParametersQmu(&parameters,iomodel,solution_type,analysis_type);

	/*Go through all parameters, and convert units to SI: */
	parameters->UnitConversion(ExtToIuEnum);

	/*Assign output pointer: */
	*pparameters=parameters;
}
