/*
 * UpdateElementsAndMaterialsControl:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsAndMaterialsControl(Elements* elements,Materials* materials, IoModel* iomodel){

	/*Intermediary*/
	int       i;
	int       counter;
	Element  *element = NULL;
	Material *material = NULL;
	int    numberofelements;
	int    num_control_type;
	bool   control_analysis;

	
	/*Fetch parameters: */
	iomodel->constants->FindParam(&numberofelements,NumberOfElementsEnum);
	iomodel->constants->FindParam(&control_analysis,ControlAnalysisEnum);
	iomodel->constants->FindParam(&num_control_type,NumControlTypeEnum);

	/*Now, return if no control*/
	if (!control_analysis) return;

	/*Fetch data needed: */
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);
	iomodel->FetchDataToInput(elements,VxObsEnum);
	iomodel->FetchDataToInput(elements,VyObsEnum); 
	iomodel->FetchDataToInput(elements,ThicknessObsEnum);

	iomodel->FetchData(&iomodel->control_type,NULL,NULL,ControlTypeEnum);
	iomodel->FetchData(&iomodel->weights,NULL,NULL,WeightsEnum);
	iomodel->FetchData(&iomodel->cm_min,NULL,NULL,CmMinEnum);
	iomodel->FetchData(&iomodel->cm_max,NULL,NULL,CmMaxEnum);
	for(i=0;i<num_control_type;i++){
		switch((int)iomodel->control_type[i]){
			case DhdtEnum:
				iomodel->FetchData(&iomodel->dhdt,NULL,NULL,DhdtEnum);
				break;
			case VxEnum:
				iomodel->FetchData(&iomodel->vx,NULL,NULL,VxEnum);
				break;
			case VyEnum:
				iomodel->FetchData(&iomodel->vy,NULL,NULL,VyEnum);
				break;
			case DragCoefficientEnum:
				iomodel->FetchData(&iomodel->drag_coefficient,NULL,NULL,DragCoefficientEnum);
				break;
			case RheologyBbarEnum:
				iomodel->FetchData(&iomodel->rheology_B,NULL,NULL,RheologyBEnum);
				break;
			default:
				_error_("Control %s not implemented yet",EnumToStringx((int)iomodel->control_type[i]));
		}
	}

	/*Update elements and materials: */
	counter=0;
	for (i=0;i<numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->InputUpdateFromIoModel(i,iomodel); //we need i to index into elements.

			material=(Material*)materials->GetObjectByOffset(counter);
			material->InputUpdateFromIoModel(i,iomodel); //we need i to index into elements.
			counter++;
		}
	}
	
	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->weights);
	xfree((void**)&iomodel->cm_min);
	xfree((void**)&iomodel->cm_max);
	xfree((void**)&iomodel->control_type);
	xfree((void**)&iomodel->dhdt);
	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
	xfree((void**)&iomodel->drag_coefficient);
	xfree((void**)&iomodel->rheology_B);
}
