/*!\file IntMatParam.c
 * \brief: implementation of the IntMatParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*IntMatParam constructors and destructor*/
/*FUNCTION IntMatParam::IntMatParam(){{{1*/
IntMatParam::IntMatParam(){
	return;
}
/*}}}*/
/*FUNCTION IntMatParam::IntMatParam(int enum_type,IssmIntMat value){{{1*/
IntMatParam::IntMatParam(int in_enum_type,int* in_value, int in_M,int in_N){

	enum_type=in_enum_type;
	M=in_M;
	N=in_N;

	value=(int*)xmalloc(M*N*sizeof(int));
	memcpy(value,in_value,M*N*sizeof(int));
}
/*}}}*/
/*FUNCTION IntMatParam::~IntMatParam(){{{1*/
IntMatParam::~IntMatParam(){
	xfree((void**)&value);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION IntMatParam::Echo {{{1*/
void IntMatParam::Echo(void){

	printf("IntMatParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   matrix size: %ix%i\n",this->M,this->N);

}
/*}}}*/
/*FUNCTION IntMatParam::DeepEcho{{{1*/
void IntMatParam::DeepEcho(void){

	int i,j;
	
	printf("IntMatParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   matrix size: %ix%i\n",this->M,this->N);
	for(i=0;i<this->M;i++){
		for(i=0;i<this->N;i++){
			printf("%i %i %g\n",i,j,*(this->value+N*i+j));
		}
	}
}
/*}}}*/
/*FUNCTION IntMatParam::Id{{{1*/
int    IntMatParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntMatParam::MyRank{{{1*/
int    IntMatParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION IntMatParam::Marshall{{{1*/
void  IntMatParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of IntMatParam: */
	enum_value=IntMatParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall IntMatParam data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(marshalled_dataset,&N,sizeof(N));marshalled_dataset+=sizeof(N);
	memcpy(marshalled_dataset,value,M*N*sizeof(int));marshalled_dataset+=M*N*sizeof(int);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION IntMatParam::MarshallSize{{{1*/
int   IntMatParam::MarshallSize(){
	
	return sizeof(M)
		+sizeof(N)
		+M*N*sizeof(int)
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION IntMatParam::Demarshall{{{1*/
void  IntMatParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*data: */
	memcpy(&M,marshalled_dataset,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(&N,marshalled_dataset,sizeof(N));marshalled_dataset+=sizeof(N);
	value=(int*)xmalloc(M*N*sizeof(int));
	memcpy(value,marshalled_dataset,M*N*sizeof(int));marshalled_dataset+=M*N*sizeof(int);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION IntMatParam::Enum{{{1*/
int IntMatParam::Enum(void){

	return IntMatParamEnum;

}
/*}}}*/
/*FUNCTION IntMatParam::copy{{{1*/
Object* IntMatParam::copy() {
	
	return new IntMatParam(this->enum_type,this->value,this->M,this->N);

}
/*}}}*/

/*IntMatParam virtual functions definitions: */
/*FUNCTION IntMatParam::GetParameterValue{{{1*/
void  IntMatParam::GetParameterValue(int** pintarray,int* pM,int* pN){
	int* output=NULL;

	output=(int*)xmalloc((int)(M*N*sizeof(int)));
	memcpy(output,value,M*N*sizeof(int));

	/*Assign output pointers:*/
	if(pM) *pM=M;
	if(pN) *pN=N;
	*pintarray=output;
}
/*}}}*/
/*FUNCTION IntMatParam::GetParameterName{{{1*/
char* IntMatParam::GetParameterName(void){
	return  EnumToStringx(this->enum_type);
}
/*}}}*/
/*FUNCTION IntMatParam::SetMatlabField{{{1*/
#ifdef _SERIAL_
void  IntMatParam::SetMatlabField(mxArray* dataref){

	char    *name        = NULL;
	double  *doublearray = NULL;
	int     *intarray    = NULL;
	mxArray *pfield      = NULL;
	mxArray *pfield2     = NULL;

	this->GetParameterValue(&intarray,NULL,NULL);
	name=this->GetParameterName();

	/*cast intarray into doublearray for Matlab*/
	doublearray=(double*)xmalloc(M*N*sizeof(double));
	for(int i=0;i<M*N;i++)doublearray[i]=(double)intarray[i];
	xfree((void**)&intarray);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,M);
	mxSetN(pfield,N);
	mxSetPr(pfield,doublearray);

	//transpose the matrix, written directly to matlab! from C to matlab.
	mexCallMATLAB(1,&pfield2, 1, &pfield, "transpose");
	mxSetField( dataref, 0, name,pfield2);
}
#endif
/*}}}*/
/*FUNCTION IntMatParam::SetValue{{{1*/
void  IntMatParam::SetValue(int* intarray,int in_M,int in_N){

	/*avoid leak: */
	xfree((void**)&this->value);

	this->value=(int*)xmalloc(in_M*in_N*sizeof(int));
	memcpy(this->value,intarray,in_M*in_N*sizeof(int));

	this->M=in_M;
	this->N=in_N;
}
/*}}}*/
/*FUNCTION IntMatParam::UnitConversion{{{1*/
void  IntMatParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
