/*
 * UpdateElementsHydrology:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../modules/modules.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsHydrology(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	int    numberofelements;
	
	/*Fetch data needed: */
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);
	iomodel->parameters->FindParam(&numberofelements,NumberOfElementsEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,SurfaceEnum);
	iomodel->FetchDataToInput(elements,BedEnum);
	iomodel->FetchDataToInput(elements,DragCoefficientEnum);
	iomodel->FetchDataToInput(elements,DragPEnum);
	iomodel->FetchDataToInput(elements,DragQEnum);
	iomodel->FetchDataToInput(elements,ElementOnIceShelfEnum);
	iomodel->FetchDataToInput(elements,ElementOnBedEnum);
	iomodel->FetchDataToInput(elements,ElementOnSurfaceEnum);
	iomodel->FetchDataToInput(elements,ElementOnWaterEnum);
	iomodel->FetchDataToInput(elements,ElementsTypeEnum);
	iomodel->FetchDataToInput(elements,RheologyBEnum);
	iomodel->FetchDataToInput(elements,RheologyNEnum);
	iomodel->FetchDataToInput(elements,PressureEnum);
	iomodel->FetchDataToInput(elements,TemperatureEnum);
	iomodel->FetchDataToInput(elements,BasalMeltingRateEnum);
	iomodel->FetchDataToInput(elements,WatercolumnEnum);
	iomodel->FetchDataToInput(elements,GeothermalfluxEnum);
	iomodel->FetchDataToInput(elements,VxEnum);
	iomodel->FetchDataToInput(elements,VyEnum);
	iomodel->FetchDataToInput(elements,VzEnum);

	elements->InputDuplicate(WatercolumnEnum,WaterColumnOldEnum);
	/*Free data: */
	xfree((void**)&iomodel->elements);

	
}
