/*
 * CreateElementsNodesAndMaterialsDiagnosticHoriz.c:
 */

#include "../../Container/Container.h"
#include "../../toolkits/toolkits.h"
#include "../../io/io.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "../../include/include.h"
#include "./ModelProcessorx.h"

void	CreateElementsVerticesAndMaterials(Elements** pelements,Vertices** pvertices,Materials** pmaterials, IoModel* iomodel,const int nummodels){

	/*Intermediary*/
	int i,j,k,n;
	int    dim;
	int    numberofelements;
	int    numberofvertices;

	/*DataSets: */
	Elements*     elements  = NULL;
	Vertices*     vertices = NULL;
	Materials*    materials = NULL;

	/*Fetch parameters: */
	iomodel->parameters->FindParam(&dim,DimEnum);
	iomodel->parameters->FindParam(&numberofelements,NumberOfElementsEnum);
	iomodel->parameters->FindParam(&numberofvertices,NumberOfVerticesEnum);

	/*Did we already create the elements? : */
	if(*pelements)return;

	/*First create the elements, vertices, nodes and material properties, if they don't already exist */
	elements  = new Elements(ElementsEnum);
	vertices  = new Vertices(VerticesEnum);
	materials = new Materials(MaterialsEnum);
	
	/*First, partition elements and vertices. Nodes will partitioned on a per analysis_type basis. If partitining already done, ignore: */
	ElementsAndVerticesPartitioning(&iomodel->my_elements,&iomodel->my_vertices,iomodel);
	
	/*Fetch data needed: */
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);
	iomodel->FetchData(&iomodel->elementconnectivity,NULL,NULL,ElementconnectivityEnum);
	iomodel->FetchData(&iomodel->upperelements,NULL,NULL,UpperelementsEnum);
	iomodel->FetchData(&iomodel->lowerelements,NULL,NULL,LowerelementsEnum);
	iomodel->FetchData(&iomodel->rheology_B,NULL,NULL,RheologyBEnum);
	iomodel->FetchData(&iomodel->rheology_n,NULL,NULL,RheologyNEnum);
	iomodel->FetchData(&iomodel->control_type,NULL,NULL,ControlTypeEnum);
	iomodel->FetchData(&iomodel->cm_min,NULL,NULL,CmMinEnum);
	iomodel->FetchData(&iomodel->cm_max,NULL,NULL,CmMaxEnum);
	
	/*Create elements and materials: */
	for (i=0;i<numberofelements;i++){

		if(iomodel->my_elements[i]){

			/*Create and add tria element to elements dataset: */
			if(dim==2)
			 elements->AddObject(new Tria(i+1,i,i,iomodel,nummodels));
			else
			 elements->AddObject(new Penta(i+1,i,i,iomodel,nummodels));

			/*Create and add material property to materials dataset: */
			materials->AddObject(new Matice(i+1,i,iomodel));
		}
	}
	
	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->elementconnectivity);
	xfree((void**)&iomodel->upperelements);
	xfree((void**)&iomodel->lowerelements);
	xfree((void**)&iomodel->rheology_B);
	xfree((void**)&iomodel->rheology_n);
	xfree((void**)&iomodel->control_type);
	xfree((void**)&iomodel->cm_min);
	xfree((void**)&iomodel->cm_max);

	/*Add new constrant material property tgo materials, at the end: */
	materials->AddObject(new Matpar(numberofelements+1,iomodel));//put it at the end of the materials
	
	/*Create vertices: */
	iomodel->FetchData(&iomodel->x,NULL,NULL,XEnum);
	iomodel->FetchData(&iomodel->y,NULL,NULL,YEnum);
	iomodel->FetchData(&iomodel->z,NULL,NULL,ZEnum);
	iomodel->FetchData(&iomodel->bed,NULL,NULL,BedEnum);
	iomodel->FetchData(&iomodel->thickness,NULL,NULL,ThicknessEnum);
	
	for (i=0;i<numberofvertices;i++){

		/*vertices and nodes (same number, as we are running continuous galerkin formulation: */
		if(iomodel->my_vertices[i]){
			
			/*Add vertex to vertices dataset: */
			vertices->AddObject(new Vertex(i+1,i,i,iomodel));
		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->x);
	xfree((void**)&iomodel->y);
	xfree((void**)&iomodel->z);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->thickness);

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pelements=elements;
	*pvertices=vertices;
	*pmaterials=materials;
}
