/*!\file: CreateParametersControl.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void CreateParametersControl(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){
	
	int         i;
	Parameters* parameters=NULL;
	bool        control_analysis=false;
	int         nsteps;
	int         num_control_type;
	int         num_cm_responses;
	int*        control_type=NULL;

	/*Get parameters: */
	parameters=*pparameters;

	/*retrieve some parameters: */
	parameters->FindParam(&control_analysis,ControlAnalysisEnum);

	if(control_analysis){

		/*What control type?*/
		iomodel->FetchData(&control_type,&num_control_type,NULL,ControlTypeEnum);
		parameters->AddObject(new IntVecParam(ControlTypeEnum,control_type,num_control_type));
		xfree((void**)&control_type);

		/*What solution type?*/
		if (solution_type==SteadystateSolutionEnum){
			parameters->AddObject(new BoolParam(ControlSteadyEnum,true));
		}
		else{
			parameters->AddObject(new BoolParam(ControlSteadyEnum,false));
		}

		/*Now, recover fit, optscal and maxiter as vectors: */
		iomodel->FetchData(&iomodel->cm_responses,&nsteps,&num_control_type,CmResponsesEnum);
		iomodel->FetchData(&iomodel->cm_jump,&nsteps,&num_cm_responses,CmJumpEnum);
		iomodel->FetchData(&iomodel->optscal,NULL,NULL,OptscalEnum);
		iomodel->FetchData(&iomodel->maxiter,NULL,NULL,MaxiterEnum);

		parameters->AddObject(new DoubleMatParam(OptscalEnum,iomodel->optscal,nsteps,num_control_type));
		parameters->AddObject(new DoubleMatParam(CmResponsesEnum,iomodel->cm_responses,nsteps,num_cm_responses));
		parameters->AddObject(new DoubleVecParam(CmJumpEnum,iomodel->cm_jump,nsteps));
		parameters->AddObject(new DoubleVecParam(MaxiterEnum,iomodel->maxiter,nsteps));

		xfree((void**)&iomodel->cm_responses);
		xfree((void**)&iomodel->cm_jump);
		xfree((void**)&iomodel->optscal);
		xfree((void**)&iomodel->maxiter);
	}

	/*Assign output pointer: */
	*pparameters=parameters;
}
