/*
 * CreateNodesBalancethickness.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesBalancethickness(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	int  i,j;
	int  node_id;
	int  vertex_id;
	int  io_index;
	bool continuous_galerkin=true;
	int    dim;
	int    numberofelements;
	int    numberofvertices;
	int    prognostic_DG;

	/*DataSets: */
	Nodes*    nodes = NULL;

	/*Fetch parameters: */
	iomodel->parameters->FindParam(&dim,DimEnum);
	iomodel->parameters->FindParam(&numberofelements,NumberOfElementsEnum);
	iomodel->parameters->FindParam(&numberofvertices,NumberOfVerticesEnum);
	iomodel->parameters->FindParam(&prognostic_DG,PrognosticDGEnum);

	/*Recover pointer: */
	nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes(NodesEnum);

	/*Continuous Galerkin partition of nodes: */
	if(prognostic_DG) continuous_galerkin=false;
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,continuous_galerkin);

	/*Check in 3d*/
	if(prognostic_DG && dim==3) _error_("DG 3d not implemented yet");

	/*First fetch data: */
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);
	iomodel->FetchData(&iomodel->nodeonbed,NULL,NULL,NodeOnBedEnum);
	iomodel->FetchData(&iomodel->nodeonsurface,NULL,NULL,NodeOnSurfaceEnum);
	iomodel->FetchData(&iomodel->nodeonicesheet,NULL,NULL,NodeOnIceSheetEnum);
	iomodel->FetchData(&iomodel->nodeoniceshelf,NULL,NULL,NodeOnIceShelfEnum);
	iomodel->FetchData(&iomodel->vertices_type,NULL,NULL,VerticesTypeEnum);
	iomodel->FetchData(&iomodel->nodeonwater,NULL,NULL,NodeOnWaterEnum);

	if(continuous_galerkin){

		/*Build Nodes dataset (Continuous Galerkin)*/
		for (i=0;i<numberofvertices;i++){

			if(iomodel->my_vertices[i]){

				/*Add node to nodes dataset: */
				nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,BalancethicknessAnalysisEnum));

			}
		}
	}
	else{

		/*Build Nodes dataset -> 3 for each element (Discontinuous Galerkin)*/
		for (i=0;i<numberofelements;i++){
			for (j=0;j<3;j++){

				if(iomodel->my_nodes[3*i+j]){ 

					//Get index of the vertex on which the current node is located
					vertex_id=(int)*(iomodel->elements+3*i+j); //(Matlab indexing)
					io_index=vertex_id-1;                      //(C indexing)
					_assert_(vertex_id>0 && vertex_id<=numberofvertices);

					//Compute Node id
					node_id=iomodel->nodecounter+3*i+j+1;

					/*Add node to nodes dataset: */
					nodes->AddObject(new Node(node_id,node_id-1,vertex_id,io_index,iomodel,BalancethicknessAnalysisEnum));

				}
			}
		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->nodeonbed);
	xfree((void**)&iomodel->nodeonsurface);
	xfree((void**)&iomodel->nodeonicesheet);
	xfree((void**)&iomodel->nodeonwater);
	xfree((void**)&iomodel->nodeoniceshelf);
	xfree((void**)&iomodel->vertices_type);

	/*Assign output pointer: */
	*pnodes=nodes;
}
