/*!\file: Parameters.h
 * \brief prototypes for Parameters.h
 */ 

#ifndef _CONTAINER_PARAMETERS_H_
#define  _CONTAINER_PARAMETERS_H_

/*forward declarations */
class Materials;
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class DataSet;
class Inputs;

class Parameters: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Parameters();
		Parameters(int enum_type);
		~Parameters();
		/*}}}*/
		/*numerics: {{{1*/
		bool  Exist(int enum_type);

		void  FindParam(bool* pinteger,int enum_type);
		void  FindParam(int* pinteger,int enum_type);
		void  FindParam(double* pscalar, int enum_type);
		void  FindParam(char** pstring,int enum_type);
		void  FindParam(char*** pstringarray,int* pM,int enum_type);
		void  FindParam(int** pintarray,int* pM,int enum_type);
		void  FindParam(int** pintarray,int* pM,int* PN,int enum_type);
		void  FindParam(double** pdoublearray,int* pM,int enum_type);
		void  FindParam(double** pdoublearray,int* pM,int* pN,int enum_type);
		void  FindParam(double*** parray,int* pM, int** pmdims_array,int** pndims_array,int enum_type);
		void  FindParam(Vec* pvec,int enum_type);
		void  FindParam(Mat* pmat,int enum_type);
		void  FindParam(FILE** pfid,int enum_type);
		
		void  SetParam(bool boolean,int enum_type);
		void  SetParam(int integer,int enum_type);
		void  SetParam(double scalar, int enum_type);
		void  SetParam(char* string,int enum_type);
		void  SetParam(char** stringarray,int M,int enum_type);
		void  SetParam(double* doublearray,int M,int enum_type);
		void  SetParam(double* doublearray,int M,int N,int enum_type);
		void  SetParam(int* intarray,int M,int enum_type);
		void  SetParam(int* intarray,int M,int N,int enum_type);
		void  SetParam(Vec vec,int enum_type);
		void  SetParam(Mat mat,int enum_type);
		void  SetParam(FILE* fid,int enum_type);
		void  UnitConversion(int direction_enum);

		Object* FindParamObject(int enum_type);
		/*}}}*/

};

#endif //ifndef _PARAMETERS_H_
