/*
 * UpdateElementsDiagnosticVert:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../modules/modules.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticVert(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	/*Now, is the model 3d? otherwise, do nothing: */
	if (iomodel->dim==2)return;

	/*Fetch data needed: */
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,ThicknessCoeffEnum);
	iomodel->FetchDataToInput(elements,SurfaceEnum);
	iomodel->FetchDataToInput(elements,BedEnum);
	iomodel->FetchDataToInput(elements,ElementOnIceShelfEnum);
	iomodel->FetchDataToInput(elements,ElementOnBedEnum);
	iomodel->FetchDataToInput(elements,ElementOnSurfaceEnum);
	iomodel->FetchDataToInput(elements,ElementOnWaterEnum);
	iomodel->FetchDataToInput(elements,BasalMeltingRateEnum);
	iomodel->FetchDataToInput(elements,SurfaceAccumulationRateEnum);
	iomodel->FetchDataToInput(elements,SurfaceAblationRateEnum);
	iomodel->FetchDataToInput(elements,SurfaceMassBalanceEnum);
	iomodel->FetchDataToInput(elements,VxEnum);
	iomodel->FetchDataToInput(elements,VyEnum);

	/*Free data: */
	xfree((void**)&iomodel->elements);
	
}
