/*
 * UpdateElementsDiagnosticHoriz:
 */

#include "../../../Container/Container.h"
#include "../../../modules/modules.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticHoriz(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn & !iomodel->isstokes) return;

	/*Fetch data needed: */
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);
	iomodel->FetchData(&iomodel->elements_type,NULL,NULL,ElementsTypeEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	/*Create inputs: */
	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,ThicknessCoeffEnum);
	iomodel->FetchDataToInput(elements,SurfaceEnum);
	iomodel->FetchDataToInput(elements,BedEnum);
	iomodel->FetchDataToInput(elements,DragCoefficientEnum);
	iomodel->FetchDataToInput(elements,DragPEnum);
	iomodel->FetchDataToInput(elements,DragQEnum);
	iomodel->FetchDataToInput(elements,DragTypeEnum);
	iomodel->FetchDataToInput(elements,ElementOnIceShelfEnum);
	iomodel->FetchDataToInput(elements,ElementOnWaterEnum);
	iomodel->FetchDataToInput(elements,RheologyBEnum);
	iomodel->FetchDataToInput(elements,RheologyNEnum);
	iomodel->FetchDataToInput(elements,VxEnum,VxObsEnum,0);
	iomodel->FetchDataToInput(elements,VyEnum,VyObsEnum,0);
	iomodel->FetchDataToInput(elements,BathymetryEnum);

	if (iomodel->dim==3){
		iomodel->FetchDataToInput(elements,ElementOnBedEnum);
		iomodel->FetchDataToInput(elements,ElementOnSurfaceEnum);
		iomodel->FetchDataToInput(elements,VzEnum);
		iomodel->FetchDataToInput(elements,SurfaceAccumulationRateEnum);
		iomodel->FetchDataToInput(elements,SurfaceAblationRateEnum);
		iomodel->FetchDataToInput(elements,SurfaceMassBalanceEnum);
		iomodel->FetchDataToInput(elements,BasalMeltingRateEnum);
		iomodel->FetchDataToInput(elements,NodeOnStokesEnum);
	}

	if(iomodel->control_analysis){
		iomodel->FetchDataToInput(elements,VxObsEnum);
		iomodel->FetchDataToInput(elements,VyObsEnum);
	}

	/*Post-process: */

	elements->InputDuplicate(VxEnum,VxPicardEnum);
	elements->InputDuplicate(VxEnum,VxObsEnum);
	if(iomodel->qmu_analysis)elements->InputDuplicate(VxEnum,QmuVxEnum);
	
	elements->InputDuplicate(VyEnum,VyPicardEnum);
	elements->InputDuplicate(VyEnum,VyObsEnum);
	if(iomodel->qmu_analysis)elements->InputDuplicate(VyEnum,QmuVyEnum);
	
	if(iomodel->dim==3){
		elements->InputDuplicate(VzEnum,VzPicardEnum);
		elements->InputDuplicate(VzEnum,VzObsEnum);
		if(iomodel->qmu_analysis)elements->InputDuplicate(VzEnum,QmuVzEnum);
	}
	
	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->elements_type);
}
