/*
 * CreateNodesThermal.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../include/include.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesThermal(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	int i;
	bool continuous_galerkin=true;

	/*DataSets: */
	Nodes*    nodes = NULL;
	
	/*Recover pointer: */
	nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes(NodesEnum);

	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,continuous_galerkin);

	/*Create nodes and vertices: */
	iomodel->FetchData(&iomodel->nodeonbed,NULL,NULL,NodeOnBedEnum);
	iomodel->FetchData(&iomodel->nodeonsurface,NULL,NULL,NodeOnSurfaceEnum);
	iomodel->FetchData(&iomodel->nodeonicesheet,NULL,NULL,NodeOnIceSheetEnum);
	iomodel->FetchData(&iomodel->nodeoniceshelf,NULL,NULL,NodeOnIceShelfEnum);
	iomodel->FetchData(&iomodel->vertices_type,NULL,NULL,VerticesTypeEnum);
	iomodel->FetchData(&iomodel->nodeonwater,NULL,NULL,NodeOnWaterEnum);

	for (i=0;i<iomodel->numberofvertices;i++){

		if(iomodel->my_vertices[i]){
			
			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,ThermalAnalysisEnum));

		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->nodeonbed);
	xfree((void**)&iomodel->nodeonsurface);
	xfree((void**)&iomodel->nodeonicesheet);
	xfree((void**)&iomodel->nodeonwater);
	xfree((void**)&iomodel->nodeoniceshelf);
	xfree((void**)&iomodel->vertices_type);	
	
	/*Assign output pointer: */
	*pnodes=nodes;
}
