/*
 * UpdateElementsSurfaceSlope:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsSurfaceSlope(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	/*Fetch data needed: */
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	IoModelToInputsx(elements,iomodel,SurfaceEnum);
	IoModelToInputsx(elements,iomodel,BedEnum);
	IoModelToInputsx(elements,iomodel,ElementOnWaterEnum);
	
	if (iomodel->dim==3){
		IoModelToInputsx(elements,iomodel,ElementOnBedEnum);
		IoModelToInputsx(elements,iomodel,ElementOnSurfaceEnum);
	}
	
	/*Free data: */
	xfree((void**)&iomodel->elements);

}
