/*
 * UpdateElementsDiagnosticVert:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../modules/modules.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticVert(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	/*Now, is the model 3d? otherwise, do nothing: */
	if (iomodel->dim==2)return;

	/*Fetch data needed: */
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	IoModelToInputsx(elements,iomodel,ThicknessEnum);
	IoModelToInputsx(elements,iomodel,ThicknessCoeffEnum);
	IoModelToInputsx(elements,iomodel,SurfaceEnum);
	IoModelToInputsx(elements,iomodel,BedEnum);
	IoModelToInputsx(elements,iomodel,ElementOnIceShelfEnum);
	IoModelToInputsx(elements,iomodel,ElementOnBedEnum);
	IoModelToInputsx(elements,iomodel,ElementOnSurfaceEnum);
	IoModelToInputsx(elements,iomodel,ElementOnWaterEnum);
	IoModelToInputsx(elements,iomodel,BasalMeltingRateEnum);
	IoModelToInputsx(elements,iomodel,SurfaceAccumulationRateEnum);
	IoModelToInputsx(elements,iomodel,SurfaceAblationRateEnum);
	IoModelToInputsx(elements,iomodel,SurfaceMassBalanceEnum);
	IoModelToInputsx(elements,iomodel,VxEnum);
	IoModelToInputsx(elements,iomodel,VyEnum);

	/*Free data: */
	xfree((void**)&iomodel->elements);
	
}
