/*
 * UpdateElementsDiagnosticHutter:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../modules/modules.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticHutter(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	/*Now, is the flag hutter on? otherwise, do nothing: */
	if (!iomodel->ishutter)return;

	/*Fetch data needed: */
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);
	iomodel->FetchData(&iomodel->elements_type,NULL,NULL,ElementsTypeEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}
	
	IoModelToInputsx(elements,iomodel,NodeOnHutterEnum);
	IoModelToInputsx(elements,iomodel,ThicknessEnum);
	IoModelToInputsx(elements,iomodel,ThicknessCoeffEnum);
	
	/*Free data: */
	xfree((void**)&iomodel->elements);

}
