/*
 * UpdateElementsDiagnosticHoriz:
 */

#include "../../../Container/Container.h"
#include "../../../modules/modules.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticHoriz(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn & !iomodel->isstokes) return;

	/*Fetch data needed: */
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);
	iomodel->FetchData(&iomodel->elements_type,NULL,NULL,ElementsTypeEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	/*Create inputs: */
	IoModelToInputsx(elements,iomodel,ThicknessEnum);
	IoModelToInputsx(elements,iomodel,ThicknessCoeffEnum);
	IoModelToInputsx(elements,iomodel,SurfaceEnum);
	IoModelToInputsx(elements,iomodel,BedEnum);
	IoModelToInputsx(elements,iomodel,DragCoefficientEnum);
	IoModelToInputsx(elements,iomodel,DragPEnum);
	IoModelToInputsx(elements,iomodel,DragQEnum);
	IoModelToInputsx(elements,iomodel,DragTypeEnum);
	IoModelToInputsx(elements,iomodel,ElementOnIceShelfEnum);
	IoModelToInputsx(elements,iomodel,ElementOnWaterEnum);
	IoModelToInputsx(elements,iomodel,RheologyBEnum);
	IoModelToInputsx(elements,iomodel,RheologyNEnum);
	IoModelToInputsx(elements,iomodel,VxEnum,VxObsEnum,0);
	IoModelToInputsx(elements,iomodel,VyEnum,VyObsEnum,0);
	IoModelToInputsx(elements,iomodel,BathymetryEnum);

	if (iomodel->dim==3){
		IoModelToInputsx(elements,iomodel,ElementOnBedEnum);
		IoModelToInputsx(elements,iomodel,ElementOnSurfaceEnum);
		IoModelToInputsx(elements,iomodel,VzEnum);
		IoModelToInputsx(elements,iomodel,SurfaceAccumulationRateEnum);
		IoModelToInputsx(elements,iomodel,SurfaceAblationRateEnum);
		IoModelToInputsx(elements,iomodel,SurfaceMassBalanceEnum);
		IoModelToInputsx(elements,iomodel,BasalMeltingRateEnum);
		IoModelToInputsx(elements,iomodel,NodeOnStokesEnum);
	}

	if(iomodel->control_analysis){
		IoModelToInputsx(elements,iomodel,VxObsEnum);
		IoModelToInputsx(elements,iomodel,VyObsEnum);
	}

	/*Post-process: */

	elements->InputDuplicate(VxEnum,VxPicardEnum);
	elements->InputDuplicate(VxEnum,VxObsEnum);
	if(iomodel->qmu_analysis)elements->InputDuplicate(VxEnum,QmuVxEnum);
	
	elements->InputDuplicate(VyEnum,VyPicardEnum);
	elements->InputDuplicate(VyEnum,VyObsEnum);
	if(iomodel->qmu_analysis)elements->InputDuplicate(VyEnum,QmuVyEnum);
	
	if(iomodel->dim==3){
		elements->InputDuplicate(VzEnum,VzPicardEnum);
		elements->InputDuplicate(VzEnum,VzObsEnum);
		if(iomodel->qmu_analysis)elements->InputDuplicate(VzEnum,QmuVzEnum);
	}
	
	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->elements_type);
}
