/*! \file CreateLoadsDiagnosticHoriz.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsDiagnosticHoriz(Loads** ploads, IoModel* iomodel){

	/*DataSets*/
	Loads     *loads     = NULL;
	Icefront  *icefront  = NULL;
	Riftfront *riftfront = NULL;
	Pengrid   *pengrid   = NULL;

	/*Intermediary*/
	int segment_width;
	int element;
	int i;
	int count=0;
	int penpair_ids[2];

	/*Recover pointer: */
	loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads(LoadsEnum);

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn & !iomodel->isstokes)goto cleanup_and_return;
	
	/*Create pressure loads as boundary conditions. Pay attention to the partitioning if we are running in parallel (the nodes
	 * referenced by a certain load must belong to the cluster node): */
	iomodel->FetchData(&iomodel->pressureload,&iomodel->numberofpressureloads,NULL,PressureloadEnum);
	iomodel->FetchData(&iomodel->elements_type,NULL,NULL,ElementsTypeEnum);
	iomodel->FetchData(&iomodel->thickness,NULL,NULL,ThicknessEnum);
	iomodel->FetchData(&iomodel->bed,NULL,NULL,BedEnum);

	/*Initialize counter: */
	count=0;

	/*First load data:*/
	for (i=0;i<iomodel->numberofpressureloads;i++){
		
		/*Retrieve element to which this icefront belongs: */
		if (iomodel->dim==2) segment_width=4; 
		else segment_width=6;
		element=(int)(*(iomodel->pressureload+segment_width*i+segment_width-2)-1); //element is in the penultimate column (node1 node2 ... elem fill)

		/*Now, if this element is not in the partition, pass: */
		if(!iomodel->my_elements[element]) continue;
		
		/*Do not create ice front if Hutter or Stokes elements*/
		if ((int)*(iomodel->elements_type+element)==HutterApproximationEnum) continue;

		/*Create and  add load: */
		if ((int)*(iomodel->elements_type+element)==(MacAyealApproximationEnum) && iomodel->dim==2){
			loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,MacAyeal2dIceFrontEnum,DiagnosticHorizAnalysisEnum));
			count++;
		}
		else if ((int)*(iomodel->elements_type+element)==(MacAyealApproximationEnum) && iomodel->dim==3){
			loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,MacAyeal3dIceFrontEnum,DiagnosticHorizAnalysisEnum));
			count++;
		}
		else if ((int)*(iomodel->elements_type+element)==(PattynApproximationEnum)){
			loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,PattynIceFrontEnum,DiagnosticHorizAnalysisEnum));
			count++;
		}
		else if ((int)*(iomodel->elements_type+element)==(StokesApproximationEnum)){
			loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,StokesIceFrontEnum,DiagnosticHorizAnalysisEnum));
			count++;
		}
		else if ((int)*(iomodel->elements_type+element)==(MacAyealPattynApproximationEnum)){
			loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,MacAyeal3dIceFrontEnum,DiagnosticHorizAnalysisEnum));
			count++;
			loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,PattynIceFrontEnum,DiagnosticHorizAnalysisEnum));
			count++;
		}
		else if ((int)*(iomodel->elements_type+element)==(PattynStokesApproximationEnum)){
			loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,PattynIceFrontEnum,DiagnosticHorizAnalysisEnum));
			count++;
			loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,StokesIceFrontEnum,DiagnosticHorizAnalysisEnum));
			count++;
		}
		else if ((int)*(iomodel->elements_type+element)==(MacAyealStokesApproximationEnum)){
			loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,MacAyeal3dIceFrontEnum,DiagnosticHorizAnalysisEnum));
			count++;
			loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,StokesIceFrontEnum,DiagnosticHorizAnalysisEnum));
			count++;
		}
	}

	/*Free data: */
	xfree((void**)&iomodel->pressureload);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);

	/*create penalties for nodes on the base of icesheet. We must have wb=ub*db/dx+vb*db/dy */
	iomodel->FetchData(&iomodel->nodeonbed,NULL,NULL,NodeOnBedEnum);
	iomodel->FetchData(&iomodel->nodeonicesheet,NULL,NULL,NodeOnIceSheetEnum);
	iomodel->FetchData(&iomodel->nodeonstokes,NULL,NULL,NodeOnStokesEnum);
	iomodel->FetchData(&iomodel->elements,NULL,NULL,ElementsEnum);
	iomodel->FetchData(&iomodel->spcvx,NULL,NULL,SpcvxEnum);
	iomodel->FetchData(&iomodel->spcvy,NULL,NULL,SpcvyEnum);
	iomodel->FetchData(&iomodel->spcvz,NULL,NULL,SpcvzEnum);
	iomodel->FetchData(&iomodel->vertices_type,NULL,NULL,VerticesTypeEnum);
	CreateSingleNodeToElementConnectivity(iomodel);
	
	for (i=0;i<iomodel->numberofvertices;i++){
		
		if(iomodel->my_vertices[i]==1 && iomodel->singlenodetoelementconnectivity[i]!=0){

			//if ((iomodel->nodeonbed[i]) && (iomodel->nodeonstokes[i])){
			if ((iomodel->nodeonbed[i]) && (iomodel->nodeonicesheet[i]) && (iomodel->nodeonstokes[i])){
				
				loads->AddObject(new Pengrid(iomodel->loadcounter+count+1,i,iomodel,DiagnosticHorizAnalysisEnum));
				count++;
			}
		} //if((iomodel->my_vertices[i]==1))
	}

	xfree((void**)&iomodel->nodeonbed);
	xfree((void**)&iomodel->nodeonstokes);
	xfree((void**)&iomodel->nodeonicesheet);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->spcvx);
	xfree((void**)&iomodel->spcvy);
	xfree((void**)&iomodel->spcvz);
	xfree((void**)&iomodel->vertices_type);
	xfree((void**)&iomodel->singlenodetoelementconnectivity);

	/*Create Penpair for penalties: */
	iomodel->FetchData(&iomodel->penalties,&iomodel->numpenalties,NULL,PenaltiesEnum);
	
	for(i=0;i<iomodel->numpenalties;i++){

		if(iomodel->my_vertices[(int)iomodel->penalties[2*i+0]-1]){

			/*In debugging mode, check that the second node is in the same cpu*/
			_assert_(iomodel->my_vertices[(int)iomodel->penalties[2*i+1]-1]);

			/*Get node ids*/
			penpair_ids[0]=iomodel->nodecounter+(int)iomodel->penalties[2*i+0];
			penpair_ids[1]=iomodel->nodecounter+(int)iomodel->penalties[2*i+1];

			/*Create Load*/
			loads->AddObject(new Penpair(iomodel->loadcounter+count+1,&penpair_ids[0],DiagnosticHorizAnalysisEnum));
			count++;
		}
	}

	/*free ressources: */
	xfree((void**)&iomodel->penalties);

	/*Create Riffront loads for rifts: */
	iomodel->FetchData(&iomodel->riftinfo,&iomodel->numrifts,NULL,RiftinfoEnum);
	iomodel->FetchData(&iomodel->thickness,NULL,NULL,ThicknessEnum);
	iomodel->FetchData(&iomodel->bed,NULL,NULL,BedEnum);
	iomodel->FetchData(&iomodel->surface,NULL,NULL,SurfaceEnum);
	iomodel->FetchData(&iomodel->nodeoniceshelf,NULL,NULL,NodeOnIceShelfEnum);

	
	for(i=0;i<iomodel->numrifts;i++){

		if(iomodel->my_elements[(int)*(iomodel->riftinfo+RIFTINFOSIZE*i+2)-1]){
			loads->AddObject(new Riftfront(iomodel->loadcounter+count+1,i,iomodel,DiagnosticHorizAnalysisEnum));
			count++;
		}
	}
				
	/*free ressources: */
	xfree((void**)&iomodel->riftinfo);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->nodeoniceshelf);

	cleanup_and_return:

	/*Assign output pointer: */
	*ploads=loads;
}
