/*!\file IoModelToInputsx
 * \brief: used in ModelProcessor, to retrieve a nodal vector  and to * create corresponding inputs inside the elements. 
 */

#include "./IoModelToInputsx.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void IoModelToInputsx(Elements* elements,IoModel* iomodel,int vector_enum,int default_vector_enum,double default_value){
	

	/*intermediary: */
	int     i;
	bool    defaulting    = false;
	bool    transient     = false;

	FILE   *fid           = NULL;
	int     code          = 0;
	int     vector_layout = 0;
	int     counter;
	int     nods;
	int     nel;


	/*variables being fetched: */
	bool    boolean;
	int     integer;
	double  scalar;
	char   *string        = NULL;
	double *doublevector  = NULL;
	int     M,N;

	/*First of, find the record for the enum, and get code  of data type: */
	fid=iomodel->SetFilePointerToData(&code, &vector_layout,vector_enum);

	switch(code){
		case 1: //boolean constant.  {{{1
			iomodel->FetchData(&boolean,vector_enum);

			/*Add boolean constant input to all elements: */
			counter=0;
			for (i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]){
					Element* element=(Element*)elements->GetObjectByOffset(counter);
					element->InputCreate((double)boolean,vector_enum,code); 
					counter++;
				}
			}
			break; /*}}}*/
		case 2: //integer constant.  {{{1
			iomodel->FetchData(&integer,vector_enum);

			/*Add integer constant input to all elements: */
			counter=0;
			for (i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]){
					Element* element=(Element*)elements->GetObjectByOffset(counter);
					element->InputCreate((double)integer,vector_enum,code); 
					counter++;
				}
			}
			break; /*}}}*/
		case 3: //double constant.  {{{1
			iomodel->FetchData(&scalar,vector_enum);

			/*Add double constant input to all elements: */
			counter=0;
			for (i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]){
					Element* element=(Element*)elements->GetObjectByOffset(counter);
					element->InputCreate(scalar,vector_enum,code); 
					counter++;
				}
			}
			break; /*}}}*/
		case 5: //boolean vector.  {{{1

			/*Fetch vector:*/
			iomodel->FetchData(&doublevector,&M,&N,vector_enum); //we still have a doublevector, because it might include times in transient mode
			/*Check we got something, otherwise fetch default: */
			if(doublevector){ 
				defaulting=false;  //we are not defaulting, because  we do have a vector
			}
			else{
				/*do we have a default enum to go fetch? */
				if(default_vector_enum!=NoneEnum){
					/*yes. fetch it: */
					iomodel->FetchData(&doublevector,&M,&N,default_vector_enum);
					if(doublevector){
						defaulting=false;  //we are not defaulting, because  we do have a vector
					}
					else{
						/*even the default vector is non existent. we are defaulting to the default value: */
						defaulting=true;
					}
				}
				else{
					/*we are left with the default value: */
					defaulting=true;
				}
			}

			/*Create inputs:*/
			counter=0;
			for (i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]){
					Element* element=(Element*)elements->GetObjectByOffset(counter);
					if(defaulting) element->InputCreate(default_value,vector_enum,code); 
					else           element->InputCreate(doublevector,i,iomodel,M,N,vector_layout,vector_enum,code);//we need i to index into elements.
					counter++;
				}
			}
			break; /*}}}*/
		case 6: //int vector.  {{{1

			/*Fetch vector:*/
			iomodel->FetchData(&doublevector,&M,&N,vector_enum); //we still have a doublevector, because it might include times in transient mode
			/*Check we got something, otherwise fetch default: */
			if(doublevector){ 
				defaulting=false;  //we are not defaulting, because  we do have a vector
			}
			else{
				/*do we have a default enum to go fetch? */
				if(default_vector_enum!=NoneEnum){
					/*yes. fetch it: */
					iomodel->FetchData(&doublevector,&M,&N,default_vector_enum);
					if(doublevector){
						defaulting=false;  //we are not defaulting, because  we do have a vector
					}
					else{
						/*even the default vector is non existent. we are defaulting to the default value: */
						defaulting=true;
					}
				}
				else{
					/*we are left with the default value: */
					defaulting=true;
				}
			}

			/*Create inputs:*/
			counter=0;
			for (i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]){
					Element* element=(Element*)elements->GetObjectByOffset(counter);
					if(defaulting) element->InputCreate(default_value,vector_enum,code); 
					else           element->InputCreate(doublevector,i,iomodel,M,N,vector_layout,vector_enum,code);//we need i to index into elements.
					counter++;
				}
			}
			break; /*}}}*/
		case 7: //double vector.  {{{1

			/*Fetch vector:*/
			iomodel->FetchData(&doublevector,&M,&N,vector_enum);
			/*Check we got something, otherwise fetch default: */
			if(doublevector){ 
				defaulting=false;  //we are not defaulting, because  we do have a vector
			}
			else{
				/*do we have a default enum to go fetch? */
				if(default_vector_enum!=NoneEnum){
					/*yes. fetch it: */
					iomodel->FetchData(&doublevector,&M,&N,default_vector_enum);
					if(doublevector){
						defaulting=false;  //we are not defaulting, because  we do have a vector
					}
					else{
						/*even the default vector is non existent. we are defaulting to the default value: */
						defaulting=true;
					}
				}
				else{
					/*we are left with the default value: */
					defaulting=true;
				}
			}

			/*Create inputs:*/
			counter=0;
			for (i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]){
					Element* element=(Element*)elements->GetObjectByOffset(counter);
					if(defaulting) element->InputCreate(default_value,vector_enum,code); 
					else           element->InputCreate(doublevector,i,iomodel,M,N,vector_layout,vector_enum,code);//we need i to index into elements.
					counter++;
				}
			}

			break; /*}}}*/
		default: /*{{{1*/
			_error_("%s%i%s","data code ",code," not supported yet!");
			break;
			/*}}}*/
	}
	/*Free ressources:*/
	xfree((void**)&doublevector);
	xfree((void**)&string);
}
